/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate5;

import io.micronaut.core.annotation.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    private static final Logger LOG = LoggerFactory.getLogger(SessionFactoryUtils.class);

    static void flush(Session session, boolean synch) {
        if (synch) {
            LOG.debug("Flushing Hibernate Session on transaction synchronization");
        } else {
            LOG.debug("Flushing Hibernate Session on explicit request");
        }
        session.flush();
    }

    static void closeSession(@Nullable Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (HibernateException ex) {
                LOG.debug("Could not close Hibernate Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOG.debug("Unexpected exception on closing Hibernate Session", ex);
            }
        }
    }
}

