/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.annotation;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.common.annotation.ValueResolver;
import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.annotation.AbstractMethodInvocationProcessor;
import io.micrometer.tracing.annotation.ContinueSpan;
import io.micrometer.tracing.annotation.NewSpan;
import io.micrometer.tracing.annotation.NewSpanParser;
import io.micrometer.tracing.annotation.SpanTagAnnotationHandler;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;

public class ImperativeMethodInvocationProcessor
extends AbstractMethodInvocationProcessor {
    public ImperativeMethodInvocationProcessor(NewSpanParser newSpanParser, Tracer tracer, Function<Class<? extends ValueResolver>, ? extends ValueResolver> resolverProvider, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> expressionResolverProvider) {
        super(newSpanParser, tracer, tracer.currentTraceContext(), new SpanTagAnnotationHandler(resolverProvider, expressionResolverProvider));
    }

    @Override
    public Object process(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        return this.proceedUnderSynchronousSpan(invocation, newSpan, continueSpan);
    }

    private Object proceedUnderSynchronousSpan(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        boolean startNewSpan;
        Span span = this.tracer.currentSpan();
        boolean bl = startNewSpan = newSpan != null || span == null;
        if (startNewSpan) {
            span = this.tracer.nextSpan();
            this.newSpanParser.parse(invocation, newSpan, span);
            span.start();
        }
        String log = this.log(continueSpan);
        boolean hasLog = StringUtils.isNotBlank((String)log);
        try {
            Tracer.SpanInScope scope = this.tracer.withSpan(span);
            try {
                this.before(invocation, span, log, hasLog);
                Object object = invocation.proceed();
                if (scope != null) {
                    scope.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.onFailure(span, log, hasLog, ex);
                    throw ex;
                }
            }
        }
        finally {
            this.after(span, startNewSpan, log, hasLog);
        }
    }
}

