/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;

public class OtelTraceContext
implements TraceContext {
    final AtomicReference<Context> otelContext;
    final SpanContext delegate;
    final @Nullable Span span;

    OtelTraceContext(@Nullable Context context, SpanContext delegate, @Nullable Span span) {
        this(new AtomicReference<Context>(context == null ? Context.current() : context), delegate, span);
    }

    OtelTraceContext(AtomicReference<Context> context, SpanContext delegate, @Nullable Span span) {
        this.otelContext = context;
        this.delegate = delegate;
        this.span = span;
    }

    OtelTraceContext(SpanContext delegate, @Nullable Span span) {
        this.otelContext = OtelTraceContext.context(span);
        this.delegate = delegate;
        this.span = span;
    }

    OtelTraceContext(Span span) {
        this(OtelTraceContext.context(span), span.getSpanContext(), span);
    }

    private static AtomicReference<Context> context(@Nullable Span span) {
        if (span instanceof SpanFromSpanContext) {
            Context contextFromParent = ((SpanFromSpanContext)span).parentTraceContext.context();
            return new AtomicReference<Context>(contextFromParent);
        }
        return new AtomicReference<Context>(Context.current());
    }

    public static TraceContext fromOtel(SpanContext context) {
        return new OtelTraceContext(context, null);
    }

    public static Context toOtelContext(TraceContext context) {
        if (context instanceof OtelTraceContext) {
            Span span = ((OtelTraceContext)context).span;
            if (span != null) {
                return span.storeInContext(Context.current());
            }
            return Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)((OtelTraceContext)context).delegate));
        }
        return Context.current();
    }

    public static @Nullable SpanContext toOtelSpanContext(TraceContext context) {
        if (context instanceof OtelTraceContext) {
            return ((OtelTraceContext)context).delegate;
        }
        return null;
    }

    public String traceId() {
        return this.delegate.getTraceId();
    }

    public @Nullable String parentId() {
        Span spanContextSpanOrSpan;
        Span span = spanContextSpanOrSpan = this.span instanceof SpanFromSpanContext ? ((SpanFromSpanContext)this.span).span : this.span;
        if (spanContextSpanOrSpan instanceof ReadableSpan) {
            ReadableSpan readableSpan = (ReadableSpan)spanContextSpanOrSpan;
            String parentSpanId = readableSpan.toSpanData().getParentSpanId();
            if (Objects.equals(Span.getInvalid().getSpanContext().getSpanId(), parentSpanId)) {
                return null;
            }
            return parentSpanId;
        }
        return null;
    }

    public String spanId() {
        return this.delegate.getSpanId();
    }

    public @Nullable Boolean sampled() {
        return this.delegate.isSampled();
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    Context context() {
        Context ctx = this.otelContext.get();
        return ctx != null ? ctx : Context.root();
    }

    SpanContext spanContext() {
        return this.delegate;
    }

    void updateContext(@Nullable Context context) {
        this.otelContext.set(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtelTraceContext otelTraceContext = (OtelTraceContext)o;
        return Objects.equals(this.delegate, otelTraceContext.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

