/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;

class OtelSpanInScope
implements Tracer.SpanInScope {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OtelSpanInScope.class);
    final Scope delegate;
    final OtelSpan span;
    final Span otelSpan;
    final SpanContext spanContext;

    OtelSpanInScope(OtelSpan span, Span otelSpan) {
        this.span = span;
        this.otelSpan = otelSpan;
        this.delegate = this.storedContext(otelSpan);
        this.spanContext = otelSpan.getSpanContext();
    }

    private Scope storedContext(Span otelSpan) {
        if (otelSpan instanceof SpanFromSpanContext) {
            SpanFromSpanContext spanFromSpanContext = (SpanFromSpanContext)otelSpan;
            return spanFromSpanContext.otelTraceContext.context().makeCurrent();
        }
        if (this.span == null || this.span.context() == null || this.span.context().context() == null) {
            return otelSpan.makeCurrent();
        }
        Context context = this.span.context().context();
        return context.with((ImplicitContextKeyed)otelSpan).makeCurrent();
    }

    public void close() {
        log.trace("Will close scope for trace context [{}]", (Object)this.spanContext);
        this.delegate.close();
    }
}

