/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.buffer.ByteBufUtil;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.nio.NioEventLoop;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import io.micrometer.shaded.io.netty.handler.timeout.IdleState;
import io.micrometer.shaded.io.netty.handler.timeout.IdleStateEvent;
import io.micrometer.shaded.io.netty.handler.timeout.IdleStateHandler;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CorePublisher;
import io.micrometer.shaded.reactor.core.publisher.BaseSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.SignalType;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.netty.ChannelOperationsId;
import io.micrometer.shaded.reactor.netty.ChannelPipelineConfigurer;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.DisposableChannel;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;
import io.micrometer.shaded.reactor.util.context.ContextView;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ReactorNetty {
    static final boolean LOG_CHANNEL_INFO = Boolean.parseBoolean(System.getProperty("io.micrometer.shaded.reactor.netty.logChannelInfo", "true"));
    public static final String IO_WORKER_COUNT = "io.micrometer.shaded.reactor.netty.ioWorkerCount";
    public static final String IO_SELECT_COUNT = "io.micrometer.shaded.reactor.netty.ioSelectCount";
    public static final String UDP_IO_THREAD_COUNT = "io.micrometer.shaded.reactor.netty.udp.ioThreadCount";
    public static final String SHUTDOWN_QUIET_PERIOD = "io.micrometer.shaded.reactor.netty.ioShutdownQuietPeriod";
    public static final String SHUTDOWN_TIMEOUT = "io.micrometer.shaded.reactor.netty.ioShutdownTimeout";
    public static final String NATIVE = "io.micrometer.shaded.reactor.netty.native";
    public static final String POOL_MAX_CONNECTIONS = "io.micrometer.shaded.reactor.netty.pool.maxConnections";
    public static final String POOL_ACQUIRE_TIMEOUT = "io.micrometer.shaded.reactor.netty.pool.acquireTimeout";
    public static final String POOL_MAX_IDLE_TIME = "io.micrometer.shaded.reactor.netty.pool.maxIdleTime";
    public static final String POOL_MAX_LIFE_TIME = "io.micrometer.shaded.reactor.netty.pool.maxLifeTime";
    public static final String POOL_LEASING_STRATEGY = "io.micrometer.shaded.reactor.netty.pool.leasingStrategy";
    public static final String POOL_GET_PERMITS_SAMPLING_RATE = "io.micrometer.shaded.reactor.netty.pool.getPermitsSamplingRate";
    public static final String POOL_RETURN_PERMITS_SAMPLING_RATE = "io.micrometer.shaded.reactor.netty.pool.returnPermitsSamplingRate";
    public static final String SSL_HANDSHAKE_TIMEOUT = "io.micrometer.shaded.reactor.netty.tcp.sslHandshakeTimeout";
    public static final String SSL_CLIENT_DEBUG = "io.micrometer.shaded.reactor.netty.tcp.ssl.client.debug";
    public static final String SSL_SERVER_DEBUG = "io.micrometer.shaded.reactor.netty.tcp.ssl.server.debug";
    public static final String ACCESS_LOG_ENABLED = "io.micrometer.shaded.reactor.netty.http.server.accessLogEnabled";
    public static final ZoneId ZONE_ID_SYSTEM = ZoneId.systemDefault();
    static final ConnectionObserver.State CONNECTED = new ConnectionObserver.State(){

        public String toString() {
            return "[connected]";
        }
    };
    static final ConnectionObserver.State ACQUIRED = new ConnectionObserver.State(){

        public String toString() {
            return "[acquired]";
        }
    };
    static final ConnectionObserver.State CONFIGURED = new ConnectionObserver.State(){

        public String toString() {
            return "[configured]";
        }
    };
    static final ConnectionObserver.State RELEASED = new ConnectionObserver.State(){

        public String toString() {
            return "[released]";
        }
    };
    static final ConnectionObserver.State DISCONNECTING = new ConnectionObserver.State(){

        public String toString() {
            return "[disconnecting]";
        }
    };
    static final ChannelPipelineConfigurer NOOP_CONFIGURER = (observer, ch, address) -> {};
    static final ConnectionObserver NOOP_LISTENER = (connection, newState) -> {};
    static final Logger log = Loggers.getLogger(ReactorNetty.class);
    static final AttributeKey<Boolean> PERSISTENT_CHANNEL = AttributeKey.valueOf("$PERSISTENT_CHANNEL");
    static final AttributeKey<Connection> CONNECTION = AttributeKey.valueOf("$CONNECTION");
    static final AttributeKey<ContextView> CONTEXT_VIEW = AttributeKey.valueOf("$CONTEXT_VIEW");
    static final Consumer<? super FileChannel> fileCloser = fc -> {
        block2: {
            try {
                fc.close();
            }
            catch (Throwable e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("", e);
            }
        }
    };
    static final Predicate<ByteBuf> PREDICATE_BB_FLUSH = b -> false;
    static final Predicate<Object> PREDICATE_FLUSH = o -> false;
    static final ByteBuf BOUNDARY = Unpooled.EMPTY_BUFFER;
    static final char CHANNEL_ID_PREFIX = '[';
    static final String CHANNEL_ID_SUFFIX_1 = "] ";
    static final char CHANNEL_ID_SUFFIX_2 = ' ';
    static final String ORIGINAL_CHANNEL_ID_PREFIX = "[id: 0x";
    static final int ORIGINAL_CHANNEL_ID_PREFIX_LENGTH = "[id: 0x".length();
    static final char TRACE_ID_PREFIX = '(';
    public static final Predicate<ByteBuf> PREDICATE_GROUP_FLUSH = b -> b == BOUNDARY;

    public static void safeRelease(Object msg) {
        ReferenceCounted referenceCounted;
        if (msg instanceof ReferenceCounted && (referenceCounted = (ReferenceCounted)msg).refCnt() > 0) {
            referenceCounted.release();
        }
    }

    public static String format(Channel channel, String msg) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(msg, "msg");
        if (LOG_CHANNEL_INFO) {
            StringBuilder result;
            Connection connection = Connection.from(channel);
            if (connection instanceof ChannelOperationsId) {
                String channelStr = ((ChannelOperationsId)((Object)connection)).asLongText();
                StringBuilder result2 = channelStr.charAt(0) != '(' ? new StringBuilder(1 + channelStr.length() + 2 + msg.length()).append('[').append(channelStr).append(CHANNEL_ID_SUFFIX_1) : new StringBuilder(channelStr.length() + 1 + msg.length()).append(channelStr).append(' ');
                return result2.append(msg).toString();
            }
            String channelStr = channel.toString();
            if (channelStr.charAt(0) == '[') {
                channelStr = channelStr.substring(ORIGINAL_CHANNEL_ID_PREFIX_LENGTH);
                result = new StringBuilder(1 + channelStr.length() + 1 + msg.length()).append('[').append(channelStr);
            } else {
                int ind = channelStr.indexOf(ORIGINAL_CHANNEL_ID_PREFIX);
                result = new StringBuilder(1 + (channelStr.length() - ORIGINAL_CHANNEL_ID_PREFIX_LENGTH) + 1 + msg.length()).append(channelStr.substring(0, ind)).append('[').append(channelStr.substring(ind + ORIGINAL_CHANNEL_ID_PREFIX_LENGTH));
            }
            return result.append(' ').append(msg).toString();
        }
        return msg;
    }

    public static String toPrettyHexDump(Object msg) {
        String result;
        Objects.requireNonNull(msg, "msg");
        if (msg instanceof ByteBufHolder && !Objects.equals(Unpooled.EMPTY_BUFFER, ((ByteBufHolder)msg).content())) {
            ByteBuf buffer = ((ByteBufHolder)msg).content();
            result = "\n" + ByteBufUtil.prettyHexDump(buffer);
        } else {
            result = msg instanceof ByteBuf ? "\n" + ByteBufUtil.prettyHexDump((ByteBuf)msg) : msg.toString();
        }
        return result;
    }

    @Nullable
    public static ContextView getChannelContext(Channel channel) {
        return channel.attr(CONTEXT_VIEW).get();
    }

    public static void setChannelContext(Channel channel, @Nullable ContextView contextView) {
        channel.attr(CONTEXT_VIEW).set(contextView);
    }

    public static RuntimeException wrapException(Throwable throwable) {
        return new InternalNettyException(Objects.requireNonNull(throwable));
    }

    static void addChunkedWriter(Connection c) {
        if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
            c.addHandlerLast("io.micrometer.shaded.reactor.left.chunkedWriter", new ChunkedWriteHandler());
        }
    }

    static void addHandlerBeforeReactorEndHandlers(Connection context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Handler [{}] already exists in the pipeline, decoder has been skipped"), name);
            }
            return;
        }
        String before = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("io.micrometer.shaded.reactor.right.")) continue;
            before = s;
            break;
        }
        if (before == null) {
            channel.pipeline().addLast(name, handler);
        } else {
            channel.pipeline().addBefore(before, name, handler);
        }
        ReactorNetty.registerForClose(context.isPersistent(), name, context);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Added decoder [{}] at the end of the user pipeline, full pipeline: {}"), name, channel.pipeline().names());
        }
    }

    static void addHandlerAfterReactorCodecs(Connection context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Handler [{}] already exists in the pipeline, encoder has been skipped"), name);
            }
            return;
        }
        String after = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("io.micrometer.shaded.reactor.left.")) continue;
            after = s;
        }
        if (after == null) {
            channel.pipeline().addFirst(name, handler);
        } else {
            channel.pipeline().addAfter(after, name, handler);
        }
        ReactorNetty.registerForClose(context.isPersistent(), name, context);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Added encoder [{}] at the beginning of the user pipeline, full pipeline: {}"), name, channel.pipeline().names());
        }
    }

    static boolean mustChunkFileTransfer(Connection c, Path file) {
        if (c.channel().parent() != null && c.channel().parent().pipeline().get("io.micrometer.shaded.reactor.left.h2MultiplexHandler") != null) {
            return true;
        }
        ChannelPipeline p = c.channel().pipeline();
        return p.get(SslHandler.class) != null || p.get("io.micrometer.shaded.reactor.left.compressionHandler") != null || !(c.channel().eventLoop() instanceof NioEventLoop) && !"file".equals(file.toUri().getScheme());
    }

    static void registerForClose(boolean shouldCleanupOnClose, String name, Connection context) {
        if (!shouldCleanupOnClose) {
            return;
        }
        context.onTerminate().subscribe(null, null, () -> context.removeHandler(name));
    }

    static void removeHandler(Channel channel, String name) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().remove(name);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Removed handler: {}, pipeline: {}"), name, channel.pipeline());
            }
        } else if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Non Removed handler: {}, context: {}, pipeline: {}"), name, channel.pipeline().context(name), channel.pipeline());
        }
    }

    static void replaceHandler(Channel channel, String name, ChannelHandler handler) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().replace(name, name, handler);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Replaced handler: {}, pipeline: {}"), name, channel.pipeline());
            }
        } else if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Non Replaced handler: {}, context: {}, pipeline: {}"), name, channel.pipeline().context(name), channel.pipeline());
        }
    }

    static ConnectionObserver compositeConnectionObserver(ConnectionObserver observer, ConnectionObserver other) {
        int pos;
        ConnectionObserver[] otherObservers;
        ConnectionObserver[] thizObservers;
        if (observer == ConnectionObserver.emptyListener()) {
            return other;
        }
        if (other == ConnectionObserver.emptyListener()) {
            return observer;
        }
        int length = 2;
        if (observer instanceof CompositeConnectionObserver) {
            thizObservers = ((CompositeConnectionObserver)observer).observers;
            length += thizObservers.length - 1;
        } else {
            thizObservers = null;
        }
        if (other instanceof CompositeConnectionObserver) {
            otherObservers = ((CompositeConnectionObserver)other).observers;
            length += otherObservers.length - 1;
        } else {
            otherObservers = null;
        }
        ConnectionObserver[] newObservers = new ConnectionObserver[length];
        if (thizObservers != null) {
            pos = thizObservers.length;
            System.arraycopy(thizObservers, 0, newObservers, 0, pos);
        } else {
            pos = 1;
            newObservers[0] = observer;
        }
        if (otherObservers != null) {
            System.arraycopy(otherObservers, 0, newObservers, pos, otherObservers.length);
        } else {
            newObservers[pos] = other;
        }
        return new CompositeConnectionObserver(newObservers);
    }

    static <T, V> CorePublisher<V> publisherOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> mapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, mapper));
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).map(mapper);
        }
        return Flux.from(publisher).map(mapper);
    }

    static <T, V> CorePublisher<V> publisherOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> monoMapper, Function<? super List<T>, ? extends V> fluxMapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, monoMapper));
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).map(monoMapper);
        }
        return Flux.from(publisher).collectList().map(fluxMapper);
    }

    ReactorNetty() {
    }

    static NettyInbound unavailableInbound(final Connection c) {
        return new NettyInbound(){

            @Override
            public ByteBufFlux receive() {
                return ByteBufFlux.fromInbound(Mono.error(new IllegalStateException("Receiver Unavailable")));
            }

            @Override
            public Flux<?> receiveObject() {
                return Flux.error(new IllegalStateException("Receiver Unavailable"));
            }

            @Override
            public NettyInbound withConnection(Consumer<? super Connection> withConnection) {
                withConnection.accept(c);
                return this;
            }
        };
    }

    static NettyOutbound unavailableOutbound(final Connection c) {
        return new NettyOutbound(){

            @Override
            public ByteBufAllocator alloc() {
                return c.channel().alloc();
            }

            @Override
            public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
                return this;
            }

            @Override
            public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
                return this;
            }

            @Override
            public NettyOutbound sendObject(Object message) {
                return this;
            }

            @Override
            public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
                return this;
            }

            @Override
            public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
                withConnection.accept(c);
                return this;
            }

            @Override
            public Mono<Void> then() {
                return Mono.error(new IllegalStateException("Sender Unavailable"));
            }
        };
    }

    static final class InternalNettyException
    extends RuntimeException {
        private static final long serialVersionUID = 6643227207055930902L;

        InternalNettyException(Throwable cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class SimpleConnection
    extends AtomicLong
    implements Connection {
        final Channel channel;

        SimpleConnection(Channel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public String toString() {
            return "SimpleConnection{channel=" + this.channel + '}';
        }
    }

    static final class ChannelDisposer
    extends BaseSubscriber<Void> {
        final DisposableChannel channelDisposable;

        ChannelDisposer(DisposableChannel channelDisposable) {
            this.channelDisposable = channelDisposable;
        }

        @Override
        protected void hookOnSubscribe(Subscription subscription) {
            this.request(Long.MAX_VALUE);
            this.channelDisposable.onDispose(this);
        }

        @Override
        protected void hookFinally(SignalType type) {
            if (type != SignalType.CANCEL) {
                this.channelDisposable.dispose();
            }
        }
    }

    @ChannelHandler.Sharable
    static final class ExtractorHandler
    extends ChannelInboundHandlerAdapter {
        final BiConsumer<? super ChannelHandlerContext, Object> extractor;

        ExtractorHandler(BiConsumer<? super ChannelHandlerContext, Object> extractor) {
            this.extractor = Objects.requireNonNull(extractor, "extractor");
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.extractor.accept(ctx, msg);
        }
    }

    static final class InboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onReadIdle;

        InboundIdleStateHandler(long idleTimeout, Runnable onReadIdle) {
            super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
            this.onReadIdle = Objects.requireNonNull(onReadIdle, "onReadIdle");
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.READER_IDLE) {
                this.onReadIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onWriteIdle;

        OutboundIdleStateHandler(long idleTimeout, Runnable onWriteIdle) {
            super(0L, idleTimeout, 0L, TimeUnit.MILLISECONDS);
            this.onWriteIdle = Objects.requireNonNull(onWriteIdle, "onWriteIdle");
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                this.onWriteIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundThen
    implements NettyOutbound {
        final NettyOutbound source;
        final Mono<Void> thenMono;
        static final Runnable EMPTY_CLEANUP = () -> {};

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher) {
            this(source, thenPublisher, EMPTY_CLEANUP);
        }

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher, Runnable onCleanup) {
            this.source = source;
            Objects.requireNonNull(onCleanup, "onCleanup");
            Mono<Void> parentMono = source.then();
            this.thenMono = parentMono == Mono.empty() ? (onCleanup == EMPTY_CLEANUP ? Mono.from(thenPublisher) : Mono.from(thenPublisher).doOnCancel(onCleanup).doOnError(t -> onCleanup.run())) : (onCleanup == EMPTY_CLEANUP ? parentMono.thenEmpty(thenPublisher) : parentMono.thenEmpty(thenPublisher).doOnCancel(onCleanup).doOnError(t -> onCleanup.run()));
        }

        @Override
        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.then(this.source.sendUsing(sourceInput, mappedInput, sourceCleanup));
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.source.alloc();
        }

        @Override
        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.source.withConnection(withConnection);
        }

        @Override
        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
            return this.then(this.source.send(dataStream, predicate));
        }

        @Override
        public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
            return this.then(this.source.sendObject(dataStream, predicate));
        }

        @Override
        public NettyOutbound sendObject(Object message) {
            return this.then(this.source.sendObject(message), () -> ReactorNetty.safeRelease(message));
        }

        @Override
        public Mono<Void> then() {
            return this.thenMono;
        }
    }

    static final class CompositeConnectionObserver
    implements ConnectionObserver {
        final ConnectionObserver[] observers;

        CompositeConnectionObserver(ConnectionObserver[] observers) {
            this.observers = observers;
        }

        @Override
        public Context currentContext() {
            return this.observers[this.observers.length - 1].currentContext();
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            for (ConnectionObserver observer : this.observers) {
                observer.onUncaughtException(connection, error);
            }
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            for (ConnectionObserver observer : this.observers) {
                observer.onStateChange(connection, newState);
            }
        }
    }

    static final class CompositeChannelPipelineConfigurer
    implements ChannelPipelineConfigurer {
        final ChannelPipelineConfigurer[] configurers;

        CompositeChannelPipelineConfigurer(ChannelPipelineConfigurer[] configurers) {
            this.configurers = configurers;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress remoteAddress) {
            for (ChannelPipelineConfigurer configurer : this.configurers) {
                configurer.onChannelInit(connectionObserver, channel, remoteAddress);
            }
        }

        static ChannelPipelineConfigurer compositeChannelPipelineConfigurer(ChannelPipelineConfigurer configurer, ChannelPipelineConfigurer other) {
            int pos;
            ChannelPipelineConfigurer[] otherConfigurers;
            ChannelPipelineConfigurer[] thizConfigurers;
            if (configurer == ChannelPipelineConfigurer.emptyConfigurer()) {
                return other;
            }
            if (other == ChannelPipelineConfigurer.emptyConfigurer()) {
                return configurer;
            }
            int length = 2;
            if (configurer instanceof CompositeChannelPipelineConfigurer) {
                thizConfigurers = ((CompositeChannelPipelineConfigurer)configurer).configurers;
                length += thizConfigurers.length - 1;
            } else {
                thizConfigurers = null;
            }
            if (other instanceof CompositeChannelPipelineConfigurer) {
                otherConfigurers = ((CompositeChannelPipelineConfigurer)other).configurers;
                length += otherConfigurers.length - 1;
            } else {
                otherConfigurers = null;
            }
            ChannelPipelineConfigurer[] newConfigurers = new ChannelPipelineConfigurer[length];
            if (thizConfigurers != null) {
                pos = thizConfigurers.length;
                System.arraycopy(thizConfigurers, 0, newConfigurers, 0, pos);
            } else {
                pos = 1;
                newConfigurers[0] = configurer;
            }
            if (otherConfigurers != null) {
                System.arraycopy(otherConfigurers, 0, newConfigurers, pos, otherConfigurers.length);
            } else {
                newConfigurers[pos] = other;
            }
            return new CompositeChannelPipelineConfigurer(newConfigurers);
        }
    }

    static final class ScalarMap<T, V>
    implements Callable<V> {
        final Callable<T> source;
        final Function<? super T, ? extends V> mapper;

        ScalarMap(Publisher<T> source, Function<? super T, ? extends V> mapper) {
            this.source = (Callable)((Object)source);
            this.mapper = mapper;
        }

        @Override
        public V call() throws Exception {
            T called = this.source.call();
            if (called == null) {
                return null;
            }
            return this.mapper.apply(called);
        }
    }
}

