/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepTuple2;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

final class SignalfxTimer
extends AbstractTimer {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final StepTuple2<Long, Long> countTotal;
    private final TimeWindowMax max;

    SignalfxTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, long stepMillis) {
        super(id, clock, CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig), pauseDetector, baseTimeUnit, false);
        this.countTotal = new StepTuple2(clock, stepMillis, (Object)0L, (Object)0L, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)TimeUnit.NANOSECONDS);
        this.count.increment();
        this.total.add(nanoAmount);
        this.max.record((double)amount, unit);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)((Long)this.countTotal.poll2()).longValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }
}

