/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepValue;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.DefaultExponentialHistogramSnapShot;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class DeltaBase2ExponentialHistogram
extends Base2ExponentialHistogram {
    private final StepExponentialHistogramSnapShot stepExponentialHistogramSnapShot;

    public DeltaBase2ExponentialHistogram(int maxScale, int maxBucketsCount, double zeroThreshold, @Nullable TimeUnit baseUnit, Clock clock, long stepMillis) {
        super(maxScale, maxBucketsCount, zeroThreshold, baseUnit);
        this.stepExponentialHistogramSnapShot = new StepExponentialHistogramSnapShot(clock, stepMillis, maxScale);
    }

    @Override
    public ExponentialHistogramSnapShot getLatestExponentialHistogramSnapshot() {
        return (ExponentialHistogramSnapShot)this.stepExponentialHistogramSnapShot.poll();
    }

    @Override
    synchronized void takeExponentialHistogramSnapShot() {
        this.stepExponentialHistogramSnapShot.poll();
    }

    public void close() {
        this.stepExponentialHistogramSnapShot._closingRollover();
    }

    private class StepExponentialHistogramSnapShot
    extends StepValue<ExponentialHistogramSnapShot> {
        public StepExponentialHistogramSnapShot(Clock clock, long stepMillis, int maxScale) {
            super(clock, stepMillis, (Object)DefaultExponentialHistogramSnapShot.getEmptySnapshotForScale(maxScale));
        }

        protected synchronized Supplier<ExponentialHistogramSnapShot> valueSupplier() {
            return () -> {
                ExponentialHistogramSnapShot latestSnapShot = DeltaBase2ExponentialHistogram.this.getCurrentValuesSnapshot();
                DeltaBase2ExponentialHistogram.this.reset();
                return latestSnapShot;
            };
        }

        protected ExponentialHistogramSnapShot noValue() {
            return DefaultExponentialHistogramSnapShot.getEmptySnapshotForScale(DeltaBase2ExponentialHistogram.this.getScale());
        }

        protected void _closingRollover() {
            super._closingRollover();
        }
    }
}

