/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.registry.otlp.OtlpHistogramSupport;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

class OtlpCumulativeDistributionSummary
extends CumulativeDistributionSummary
implements StartTimeAwareMeter,
OtlpHistogramSupport {
    private final long startTimeNanos;

    OtlpCumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, Histogram histogram) {
        super(id, clock, distributionStatisticConfig, scale, histogram);
        this.startTimeNanos = TimeUnit.MILLISECONDS.toNanos(clock.wallTime());
    }

    @Override
    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public @Nullable ExponentialHistogramSnapShot getExponentialHistogramSnapShot() {
        if (this.histogram instanceof Base2ExponentialHistogram) {
            return ((Base2ExponentialHistogram)this.histogram).getLatestExponentialHistogramSnapshot();
        }
        return null;
    }
}

