/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.health;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.lang.Nullable;
import io.micrometer.health.QueryUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public abstract class ServiceLevelObjective {
    private static final ThreadLocal<DecimalFormat> WHOLE_OR_SHORT_DECIMAL = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("##0.##", otherSymbols);
    });
    private final String name;
    private final Tags tags;
    @Nullable
    private final String baseUnit;
    @Nullable
    private final String failedMessage;
    private final Meter.Id id;

    protected ServiceLevelObjective(String name, Tags tags, @Nullable String baseUnit, @Nullable String failedMessage) {
        this.name = name;
        this.tags = tags;
        this.baseUnit = baseUnit;
        this.failedMessage = failedMessage;
        this.id = new Meter.Id(name, tags, baseUnit, failedMessage, Meter.Type.GAUGE);
    }

    public String getName() {
        return this.name;
    }

    public Iterable<Tag> getTags() {
        return this.tags;
    }

    @Nullable
    public String getBaseUnit() {
        return this.baseUnit;
    }

    public Meter.Id getId() {
        return this.id;
    }

    @Nullable
    public String getFailedMessage() {
        return this.failedMessage;
    }

    public abstract Collection<MeterBinder> getRequires();

    public abstract Collection<MeterFilter> getAcceptFilters();

    public abstract void tick(MeterRegistry var1);

    public abstract boolean healthy(MeterRegistry var1);

    public static MultipleIndicator.Builder compose(String name, ServiceLevelObjective ... objectives) {
        return new MultipleIndicator.Builder(name, objectives);
    }

    public static SingleIndicator.Builder build(String name) {
        return new SingleIndicator.Builder(name);
    }

    public static class MultipleIndicator
    extends ServiceLevelObjective {
        private final ServiceLevelObjective[] objectives;
        private final BinaryOperator<Boolean> combiner;

        MultipleIndicator(String name, Tags tags, @Nullable String failedMessage, ServiceLevelObjective[] objectives, BinaryOperator<Boolean> combiner) {
            super(name, tags, null, failedMessage);
            this.objectives = objectives;
            this.combiner = combiner;
        }

        @Override
        public boolean healthy(MeterRegistry registry) {
            return Arrays.stream(this.objectives).map(o -> o.healthy(registry)).reduce(this.combiner).orElse(true);
        }

        @Override
        public Collection<MeterBinder> getRequires() {
            return Arrays.stream(this.objectives).flatMap(o -> o.getRequires().stream()).collect(Collectors.toList());
        }

        public ServiceLevelObjective[] getObjectives() {
            return this.objectives;
        }

        @Override
        public Collection<MeterFilter> getAcceptFilters() {
            return Arrays.stream(this.objectives).flatMap(o -> o.getAcceptFilters().stream()).collect(Collectors.toList());
        }

        @Override
        public void tick(MeterRegistry registry) {
            for (ServiceLevelObjective objective : this.objectives) {
                objective.tick(registry);
            }
        }

        public static class Builder {
            private final String name;
            private Tags tags = Tags.empty();
            private final ServiceLevelObjective[] objectives;
            @Nullable
            private String failedMessage;

            Builder(String name, ServiceLevelObjective[] objectives) {
                this.name = name;
                this.objectives = objectives;
            }

            public final Builder failedMessage(@Nullable String failedMessage) {
                this.failedMessage = failedMessage;
                return this;
            }

            public Builder tags(String ... tags) {
                return this.tags((Iterable<Tag>)Tags.of((String[])tags));
            }

            public Builder tags(Iterable<Tag> tags) {
                this.tags = this.tags.and(tags);
                return this;
            }

            public Builder tag(String key, String value) {
                this.tags = this.tags.and(key, value);
                return this;
            }

            public final MultipleIndicator and() {
                return new MultipleIndicator(this.name, this.tags, this.failedMessage, this.objectives, (o1, o2) -> o1 != false && o2 != false);
            }

            public final MultipleIndicator or() {
                return new MultipleIndicator(this.name, this.tags, this.failedMessage, this.objectives, (o1, o2) -> o1 != false || o2 != false);
            }

            public final MultipleIndicator combine(BinaryOperator<Boolean> combiner) {
                return new MultipleIndicator(this.name, this.tags, this.failedMessage, this.objectives, combiner);
            }
        }
    }

    public static class SingleIndicator
    extends ServiceLevelObjective {
        private final NumericQuery query;
        private final Collection<MeterBinder> requires;
        private final String testDescription;
        private final Predicate<Double> test;

        protected SingleIndicator(NumericQuery query, String testDescription, Predicate<Double> test) {
            super(query.name, query.tags, query.baseUnit, query.failedMessage);
            this.query = query;
            this.requires = query.requires;
            this.testDescription = testDescription;
            this.test = test;
        }

        @Override
        public boolean healthy(MeterRegistry registry) {
            Double v = this.getValue(registry);
            return v.isNaN() || this.test.test(v);
        }

        @Override
        public void tick(MeterRegistry registry) {
            this.query.tick(registry);
        }

        @Override
        public Collection<MeterBinder> getRequires() {
            return this.requires;
        }

        @Override
        public Collection<MeterFilter> getAcceptFilters() {
            return this.query.acceptFilters();
        }

        public double getValue(MeterRegistry registry) {
            return this.query.getValue(registry);
        }

        public String getValueAsString(MeterRegistry registry) {
            double value = this.getValue(registry);
            return Double.isNaN(value) ? "no value available" : (this.getBaseUnit() != null && this.getBaseUnit().toLowerCase().contains("percent") ? ((DecimalFormat)WHOLE_OR_SHORT_DECIMAL.get()).format(value * 100.0) + "%" : ((DecimalFormat)WHOLE_OR_SHORT_DECIMAL.get()).format(value));
        }

        public String getTestDescription() {
            return this.testDescription;
        }

        static SingleIndicator testNumeric(NumericQuery query, String testDescription, Predicate<Double> test) {
            return new SingleIndicator(query, testDescription, test);
        }

        static SingleIndicator testDuration(NumericQuery query, String testDescription, Predicate<Duration> test) {
            return new SingleIndicator(query, testDescription, valueNanos -> valueNanos.isNaN() || test.test(Duration.ofNanos(valueNanos.longValue())));
        }

        public static abstract class NumericQuery {
            protected final String name;
            private final Tags tags;
            @Nullable
            private final String baseUnit;
            @Nullable
            private final String failedMessage;
            private final Collection<MeterBinder> requires;

            NumericQuery(String name, Tags tags, @Nullable String baseUnit, @Nullable String failedMessage, Collection<MeterBinder> requires) {
                this.name = name;
                this.tags = tags;
                this.baseUnit = baseUnit;
                this.failedMessage = failedMessage;
                this.requires = requires;
            }

            abstract Double getValue(MeterRegistry var1);

            private String thresholdString(double threshold) {
                return this.baseUnit != null && this.baseUnit.toLowerCase().contains("percent") ? ((DecimalFormat)WHOLE_OR_SHORT_DECIMAL.get()).format(threshold * 100.0) + "%" : ((DecimalFormat)WHOLE_OR_SHORT_DECIMAL.get()).format(threshold);
            }

            public final SingleIndicator isLessThan(double threshold) {
                return SingleIndicator.testNumeric(this, "<" + this.thresholdString(threshold), v -> v < threshold);
            }

            public final SingleIndicator isLessThanOrEqualTo(double threshold) {
                return SingleIndicator.testNumeric(this, "<=" + this.thresholdString(threshold), v -> v <= threshold);
            }

            public final SingleIndicator isGreaterThan(double threshold) {
                return SingleIndicator.testNumeric(this, ">" + this.thresholdString(threshold), v -> v > threshold);
            }

            public final SingleIndicator isGreaterThanOrEqualTo(double threshold) {
                return SingleIndicator.testNumeric(this, ">=" + this.thresholdString(threshold), v -> v >= threshold);
            }

            public final SingleIndicator isEqualTo(double threshold) {
                return SingleIndicator.testNumeric(this, "==" + this.thresholdString(threshold), v -> v == threshold);
            }

            public final SingleIndicator isLessThan(Duration threshold) {
                return SingleIndicator.testDuration(this, "<" + threshold, v -> v.compareTo(threshold) < 0);
            }

            public final SingleIndicator isLessThanOrEqualTo(Duration threshold) {
                return SingleIndicator.testDuration(this, "<=" + threshold, v -> v.compareTo(threshold) <= 0);
            }

            public final SingleIndicator isGreaterThan(Duration threshold) {
                return SingleIndicator.testDuration(this, ">" + threshold, v -> v.compareTo(threshold) > 0);
            }

            public final SingleIndicator isGreaterThanOrEqualTo(Duration threshold) {
                return SingleIndicator.testDuration(this, ">=" + threshold, v -> v.compareTo(threshold) >= 0);
            }

            public final SingleIndicator isEqualTo(Duration threshold) {
                return SingleIndicator.testDuration(this, "==" + threshold, v -> v.compareTo(threshold) == 0);
            }

            public final SingleIndicator test(String thresholdDescription, Predicate<Double> threshold) {
                return SingleIndicator.testNumeric(this, thresholdDescription, threshold);
            }

            public final SingleIndicator testDuration(String thresholdDescription, Predicate<Duration> threshold) {
                return SingleIndicator.testDuration(this, thresholdDescription, threshold);
            }

            public final NumericQuery dividedBy(Function<Builder, NumericQuery> over) {
                return new ArithmeticOp(this, over.apply(new Builder(this.name, this.failedMessage, this.requires)), (v1, v2) -> v1 / v2);
            }

            public final NumericQuery multipliedBy(Function<Builder, NumericQuery> by) {
                return new ArithmeticOp(this, by.apply(new Builder(this.name, this.failedMessage, this.requires)), (v1, v2) -> v1 * v2);
            }

            public final NumericQuery plus(Function<Builder, NumericQuery> with) {
                return new ArithmeticOp(this, with.apply(new Builder(this.name, this.failedMessage, this.requires)), Double::sum);
            }

            public final NumericQuery minus(Function<Builder, NumericQuery> with) {
                return new ArithmeticOp(this, with.apply(new Builder(this.name, this.failedMessage, this.requires)), (v1, v2) -> v1 - v2);
            }

            public final NumericQuery combineWith(Function<Builder, NumericQuery> with, BinaryOperator<Double> combiner) {
                return new ArithmeticOp(this, with.apply(new Builder(this.name, this.failedMessage, this.requires)), combiner);
            }

            public final NumericQuery maxOver(Duration interval) {
                return new OverInterval(this, interval, vs -> vs.max().orElse(Double.NaN));
            }

            public final NumericQuery minOver(Duration interval) {
                return new OverInterval(this, interval, vs -> vs.min().orElse(Double.NaN));
            }

            public final NumericQuery sumOver(Duration interval) {
                return new OverInterval(this, interval, DoubleStream::sum);
            }

            public final NumericQuery averageOver(Duration interval) {
                return new OverInterval(this, interval, vs -> vs.average().orElse(Double.NaN));
            }

            abstract Collection<MeterFilter> acceptFilters();

            abstract void tick(MeterRegistry var1);
        }

        static class OverInterval
        extends NumericQuery {
            private final Deque<Sample> samples = new ConcurrentLinkedDeque<Sample>();
            private final NumericQuery numericQuery;
            private final Duration interval;
            private final Function<DoubleStream, Double> collector;

            OverInterval(NumericQuery q, Duration interval, Function<DoubleStream, Double> collector) {
                super(q.name, q.tags, q.baseUnit, q.failedMessage, q.requires);
                this.numericQuery = q;
                this.interval = interval;
                this.collector = collector;
            }

            @Override
            protected Double getValue(MeterRegistry registry) {
                return this.collector.apply(this.samples.stream().mapToDouble(s -> ((Sample)s).sample).filter(n -> !Double.isNaN(n)));
            }

            @Override
            public Collection<MeterFilter> acceptFilters() {
                return this.numericQuery.acceptFilters();
            }

            @Override
            public void tick(MeterRegistry registry) {
                long time = registry.config().clock().monotonicTime();
                Sample first = this.samples.peekFirst();
                if (first != null && Duration.ofNanos(time - first.tick).compareTo(this.interval) > 0) {
                    this.samples.removeFirst();
                }
                this.samples.addLast(new Sample(time, this.numericQuery.getValue(registry)));
            }

            private static class Sample {
                private final long tick;
                private final double sample;

                private Sample(long tick, double sample) {
                    this.tick = tick;
                    this.sample = sample;
                }
            }
        }

        static class ArithmeticOp
        extends NumericQuery {
            private final NumericQuery left;
            private final NumericQuery right;
            private BinaryOperator<Double> combiner;

            ArithmeticOp(NumericQuery left, NumericQuery right, BinaryOperator<Double> combiner) {
                super(left.name, left.tags, left.baseUnit, left.failedMessage, left.requires);
                this.left = left;
                this.right = right;
                this.combiner = combiner;
            }

            @Override
            protected Double getValue(MeterRegistry registry) {
                return (Double)this.combiner.apply(this.left.getValue(registry), this.right.getValue(registry));
            }

            @Override
            public Collection<MeterFilter> acceptFilters() {
                ArrayList<MeterFilter> filters = new ArrayList<MeterFilter>();
                filters.addAll(this.left.acceptFilters());
                filters.addAll(this.right.acceptFilters());
                return filters;
            }

            @Override
            public void tick(MeterRegistry registry) {
                this.left.tick(registry);
                this.right.tick(registry);
            }
        }

        static class Instant
        extends NumericQuery {
            private static final CompositeMeterRegistry NOOP_REGISTRY = new CompositeMeterRegistry(Clock.SYSTEM);
            private final Function<Search, Search> search;
            private final Function<Search, Double> toValue;

            Instant(String name, Tags tags, @Nullable String baseUnit, @Nullable String failedMessage, Collection<MeterBinder> requires, Function<Search, Search> search, Function<Search, Double> toValue) {
                super(name, tags, baseUnit, failedMessage, requires);
                this.search = search;
                this.toValue = toValue;
            }

            @Override
            protected Double getValue(MeterRegistry registry) {
                return this.toValue.apply(this.search.apply(Search.in((MeterRegistry)registry)));
            }

            @Override
            public Collection<MeterFilter> acceptFilters() {
                return Collections.singleton(this.search.apply(Search.in((MeterRegistry)NOOP_REGISTRY)).acceptFilter());
            }

            @Override
            public void tick(MeterRegistry registry) {
            }
        }

        public static class Builder {
            private final String name;
            private Tags tags = Tags.empty();
            @Nullable
            private String baseUnit;
            @Nullable
            private String failedMessage;
            private final Collection<MeterBinder> requires;

            Builder(String name) {
                this(name, null, new ArrayList<MeterBinder>());
            }

            Builder(String name, @Nullable String failedMessage, Collection<MeterBinder> requires) {
                this.name = name;
                this.failedMessage = failedMessage;
                this.requires = requires;
            }

            public final Builder failedMessage(@Nullable String failedMessage) {
                this.failedMessage = failedMessage;
                return this;
            }

            public final Builder requires(MeterBinder ... requires) {
                Collections.addAll(this.requires, requires);
                return this;
            }

            public final Builder baseUnit(@Nullable String baseUnit) {
                this.baseUnit = baseUnit;
                return this;
            }

            public final Builder tags(String ... tags) {
                return this.tags((Iterable<Tag>)Tags.of((String[])tags));
            }

            public final Builder tags(Iterable<Tag> tags) {
                this.tags = this.tags.and(tags);
                return this;
            }

            public final Builder tag(String key, String value) {
                this.tags = this.tags.and(key, value);
                return this;
            }

            public final NumericQuery count(Function<Search, Search> search) {
                return new Instant(this.name, this.tags, this.baseUnit, this.failedMessage, this.requires, search, s -> s.meters().stream().map(m -> {
                    if (m instanceof Counter) {
                        return ((Counter)m).count();
                    }
                    if (m instanceof Timer) {
                        return ((Timer)m).count();
                    }
                    if (m instanceof FunctionTimer) {
                        return ((FunctionTimer)m).count();
                    }
                    if (m instanceof FunctionCounter) {
                        return ((FunctionCounter)m).count();
                    }
                    if (m instanceof LongTaskTimer) {
                        return ((LongTaskTimer)m).activeTasks();
                    }
                    return Double.NaN;
                }).reduce(Double.NaN, QueryUtils.SUM_OR_NAN));
            }

            public NumericQuery errorRatio(Function<Search, Search> searchAll, Function<Search, Search> searchErrors) {
                return this.count(searchAll.andThen(searchErrors)).dividedBy(over -> over.count(searchAll));
            }

            public final NumericQuery total(Function<Search, Search> search) {
                return new Instant(this.name, this.tags, this.baseUnit, this.failedMessage, this.requires, search, s -> s.meters().stream().map(m -> {
                    if (m instanceof DistributionSummary) {
                        return ((DistributionSummary)m).totalAmount();
                    }
                    if (m instanceof Timer) {
                        return ((Timer)m).totalTime(TimeUnit.NANOSECONDS);
                    }
                    if (m instanceof LongTaskTimer) {
                        return ((LongTaskTimer)m).duration(TimeUnit.NANOSECONDS);
                    }
                    return Double.NaN;
                }).reduce(Double.NaN, QueryUtils.SUM_OR_NAN));
            }

            public final NumericQuery maxPercentile(Function<Search, Search> search, double percentile) {
                return new Instant(this.name, this.tags, this.baseUnit, this.failedMessage, this.requires, search, s -> s.meters().stream().map(m -> {
                    if (!(m instanceof HistogramSupport)) {
                        return Double.NaN;
                    }
                    ValueAtPercentile[] valueAtPercentiles = ((HistogramSupport)m).takeSnapshot().percentileValues();
                    return Arrays.stream(valueAtPercentiles).filter(vap -> vap.percentile() == percentile).map(ValueAtPercentile::value).findAny().orElse(Double.NaN);
                }).reduce(Double.NaN, QueryUtils.MAX_OR_NAN));
            }

            public final NumericQuery max(Function<Search, Search> search) {
                return new Instant(this.name, this.tags, this.baseUnit, this.failedMessage, this.requires, search, s -> s.meters().stream().map(m -> {
                    if (m instanceof DistributionSummary) {
                        return ((DistributionSummary)m).max();
                    }
                    if (m instanceof Timer) {
                        return ((Timer)m).max(TimeUnit.NANOSECONDS);
                    }
                    if (m instanceof LongTaskTimer) {
                        return ((LongTaskTimer)m).max(TimeUnit.NANOSECONDS);
                    }
                    return Double.NaN;
                }).reduce(Double.NaN, QueryUtils.MAX_OR_NAN));
            }

            public final NumericQuery value(Function<Search, Search> search) {
                return new Instant(this.name, this.tags, this.baseUnit, this.failedMessage, this.requires, search, s -> s.meters().stream().map(m -> {
                    if (m instanceof TimeGauge) {
                        return ((TimeGauge)m).value(TimeUnit.NANOSECONDS);
                    }
                    if (m instanceof Gauge) {
                        return ((Gauge)m).value();
                    }
                    return Double.NaN;
                }).filter(n -> !Double.isNaN(n)).findAny().orElse(Double.NaN));
            }
        }
    }

    static class FilteredServiceLevelObjective
    extends ServiceLevelObjective {
        private final ServiceLevelObjective delegate;

        FilteredServiceLevelObjective(Meter.Id id, ServiceLevelObjective delegate) {
            super(id.getName(), Tags.of((Iterable)id.getTags()), id.getBaseUnit(), id.getDescription());
            this.delegate = delegate;
        }

        @Override
        public Collection<MeterBinder> getRequires() {
            return this.delegate.getRequires();
        }

        @Override
        public Collection<MeterFilter> getAcceptFilters() {
            return this.delegate.getAcceptFilters();
        }

        @Override
        public void tick(MeterRegistry registry) {
            this.delegate.tick(registry);
        }

        @Override
        public boolean healthy(MeterRegistry registry) {
            return this.delegate.healthy(registry);
        }
    }
}

