/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.ProbingPolicy;
import java.io.Closeable;

@Experimental
public interface HealthCheckStrategy
extends Closeable {
    public int getInterval();

    public int getTimeout();

    public HealthStatus doHealthCheck(RedisURI var1);

    @Override
    default public void close() {
    }

    public int getNumProbes();

    public ProbingPolicy getPolicy();

    public int getDelayInBetweenProbes();

    public static class Config {
        private static final int INTERVAL_DEFAULT = 5000;
        private static final int TIMEOUT_DEFAULT = 1000;
        private static final int NUM_PROBES_DEFAULT = 3;
        private static final int DELAY_IN_BETWEEN_PROBES_DEFAULT = 500;
        protected final int interval;
        protected final int timeout;
        protected final int numProbes;
        protected final int delayInBetweenProbes;
        protected final ProbingPolicy policy;

        public Config(int interval, int timeout, int numProbes, int delayInBetweenProbes, ProbingPolicy policy) {
            this.interval = interval;
            this.timeout = timeout;
            this.numProbes = numProbes;
            this.delayInBetweenProbes = delayInBetweenProbes;
            this.policy = policy;
        }

        Config(Builder<?, ?> builder) {
            this.interval = builder.interval;
            this.timeout = builder.timeout;
            this.numProbes = builder.numProbes;
            this.delayInBetweenProbes = builder.delayInBetweenProbes;
            this.policy = builder.policy;
        }

        public int getInterval() {
            return this.interval;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int getNumProbes() {
            return this.numProbes;
        }

        public int getDelayInBetweenProbes() {
            return this.delayInBetweenProbes;
        }

        public ProbingPolicy getPolicy() {
            return this.policy;
        }

        public static Config create() {
            return Config.builder().build();
        }

        public static Builder<?, ? extends Config> builder() {
            return new Builder();
        }

        public static class Builder<T extends Builder<T, C>, C extends Config> {
            protected int interval = 5000;
            protected int timeout = 1000;
            protected int numProbes = 3;
            protected ProbingPolicy policy = ProbingPolicy.BuiltIn.ALL_SUCCESS;
            protected int delayInBetweenProbes = 500;

            public T interval(int interval) {
                this.interval = interval;
                return (T)this;
            }

            public T timeout(int timeout) {
                this.timeout = timeout;
                return (T)this;
            }

            public T numProbes(int numProbes) {
                this.numProbes = numProbes;
                return (T)this;
            }

            public T policy(ProbingPolicy policy) {
                this.policy = policy;
                return (T)this;
            }

            public T delayInBetweenProbes(int delayInBetweenProbes) {
                this.delayInBetweenProbes = delayInBetweenProbes;
                return (T)this;
            }

            public C build() {
                return (C)new Config(this);
            }
        }
    }
}

