/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.DatabaseConfig;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.failover.health.HealthCheck;
import java.io.Closeable;

@Experimental
public class RedisDatabase<C extends StatefulRedisConnection<?, ?>>
implements Closeable {
    private final float weight;
    private final C connection;
    private final RedisURI redisURI;
    private final DatabaseEndpoint databaseEndpoint;
    private final CircuitBreaker circuitBreaker;
    private final HealthCheck healthCheck;

    public RedisDatabase(DatabaseConfig config, C connection, DatabaseEndpoint databaseEndpoint, CircuitBreaker circuitBreaker, HealthCheck healthCheck) {
        this.redisURI = config.getRedisURI();
        this.weight = config.getWeight();
        this.connection = connection;
        this.databaseEndpoint = databaseEndpoint;
        this.circuitBreaker = circuitBreaker;
        this.healthCheck = healthCheck;
    }

    public float getWeight() {
        return this.weight;
    }

    public C getConnection() {
        return this.connection;
    }

    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    public DatabaseEndpoint getDatabaseEndpoint() {
        return this.databaseEndpoint;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void close() {
        this.connection.close();
        this.circuitBreaker.close();
    }
}

