/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.Delegating;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.CircuitBreakerImpl;
import io.lettuce.core.failover.DatabaseConfig;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.failover.DatabaseEndpointImpl;
import io.lettuce.core.failover.DatabasePubSubEndpointImpl;
import io.lettuce.core.failover.DatabaseRawConnectionFactory;
import io.lettuce.core.failover.MultiDbClient;
import io.lettuce.core.failover.RedisDatabase;
import io.lettuce.core.failover.StatefulRedisMultiDbConnectionImpl;
import io.lettuce.core.failover.StatefulRedisMultiDbPubSubConnectionImpl;
import io.lettuce.core.failover.StatusTracker;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.api.StatefulRedisMultiDbPubSubConnection;
import io.lettuce.core.failover.health.HealthCheck;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthCheckStrategySupplier;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.HealthStatusManager;
import io.lettuce.core.failover.health.HealthStatusManagerImpl;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class MultiDbClientImpl
extends RedisClient
implements MultiDbClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultiDbClientImpl.class);
    private static final RedisURI EMPTY_URI = new RedisURI();
    private final Map<RedisURI, DatabaseConfig> databaseConfigs;
    private final DatabaseRawConnectionFactory databaseRawConnectionFactory = new DatabaseRawConnectionFactoryImpl();

    MultiDbClientImpl(Collection<DatabaseConfig> databaseConfigs) {
        this(null, databaseConfigs);
    }

    MultiDbClientImpl(ClientResources clientResources, Collection<DatabaseConfig> databaseConfigs) {
        super(clientResources, EMPTY_URI);
        if (databaseConfigs == null || databaseConfigs.isEmpty()) {
            this.databaseConfigs = new ConcurrentHashMap<RedisURI, DatabaseConfig>();
        } else {
            this.databaseConfigs = new ConcurrentHashMap<RedisURI, DatabaseConfig>(databaseConfigs.size());
            for (DatabaseConfig config : databaseConfigs) {
                LettuceAssert.notNull((Object)config, "DatabaseConfig must not be null");
                LettuceAssert.notNull((Object)config.getRedisURI(), "RedisURI must not be null");
                this.databaseConfigs.put(config.getRedisURI(), config);
            }
        }
    }

    @Override
    public StatefulRedisMultiDbConnection<String, String> connect() {
        return this.connect((RedisCodec)this.newStringStringCodec());
    }

    @Override
    public Collection<RedisURI> getRedisURIs() {
        return this.databaseConfigs.keySet();
    }

    @Override
    public <K, V> StatefulRedisMultiDbConnection<K, V> connect(RedisCodec<K, V> codec) {
        if (codec == null) {
            throw new IllegalArgumentException("codec must not be null");
        }
        HealthStatusManager healthStatusManager = this.createHealthStatusManager();
        ConcurrentHashMap databases = new ConcurrentHashMap(this.databaseConfigs.size());
        for (Map.Entry<RedisURI, DatabaseConfig> entry : this.databaseConfigs.entrySet()) {
            RedisURI uri = entry.getKey();
            DatabaseConfig config = entry.getValue();
            RedisDatabase<StatefulRedisConnection<K, V>> database = this.createRedisDatabase(config, codec, healthStatusManager);
            databases.put(uri, database);
        }
        StatusTracker statusTracker = new StatusTracker(healthStatusManager);
        this.waitForInitialHealthyDatabase(statusTracker, databases);
        return new StatefulRedisMultiDbConnectionImpl(databases, this.getResources(), codec, this.getOptions().getJsonParser(), this::createRedisDatabase, healthStatusManager);
    }

    protected HealthStatusManager createHealthStatusManager() {
        return new HealthStatusManagerImpl();
    }

    private <K, V> RedisDatabase<StatefulRedisConnection<K, V>> createRedisDatabase(DatabaseConfig config, RedisCodec<K, V> codec, HealthStatusManager healthStatusManager) {
        RedisURI uri = config.getRedisURI();
        StatefulRedisConnection<K, V> connection = this.connect(codec, uri);
        DatabaseEndpoint databaseEndpoint = this.extractDatabaseEndpoint(connection);
        CircuitBreakerImpl circuitBreaker = new CircuitBreakerImpl(config.getCircuitBreakerConfig());
        databaseEndpoint.bind(circuitBreaker);
        HealthCheck healthCheck = null;
        if (HealthCheckStrategySupplier.NO_HEALTH_CHECK != config.getHealthCheckStrategySupplier()) {
            HealthCheckStrategy hcStrategy = config.getHealthCheckStrategySupplier().get(config.getRedisURI(), this.databaseRawConnectionFactory);
            healthCheck = healthStatusManager.add(uri, hcStrategy);
        }
        RedisDatabase<StatefulRedisConnection<K, V>> database = new RedisDatabase<StatefulRedisConnection<K, V>>(config, connection, databaseEndpoint, circuitBreaker, healthCheck);
        return database;
    }

    @Override
    public StatefulRedisMultiDbPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub((RedisCodec)this.newStringStringCodec());
    }

    @Override
    public <K, V> StatefulRedisMultiDbPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        if (codec == null) {
            throw new IllegalArgumentException("codec must not be null");
        }
        HealthStatusManager healthStatusManager = this.createHealthStatusManager();
        ConcurrentHashMap<RedisURI, RedisDatabase<StatefulRedisPubSubConnection<RedisURI, RedisDatabase<StatefulRedisPubSubConnection<K, V>>>>> databases = new ConcurrentHashMap<RedisURI, RedisDatabase<StatefulRedisPubSubConnection<RedisURI, RedisDatabase<StatefulRedisPubSubConnection<K, V>>>>>(this.databaseConfigs.size());
        for (Map.Entry<RedisURI, DatabaseConfig> entry : this.databaseConfigs.entrySet()) {
            RedisURI uri = entry.getKey();
            DatabaseConfig config = entry.getValue();
            RedisDatabase<StatefulRedisPubSubConnection<K, V>> database = this.createRedisDatabaseWithPubSub(config, codec, healthStatusManager);
            databases.put(uri, database);
        }
        StatusTracker statusTracker = new StatusTracker(healthStatusManager);
        this.waitForInitialHealthyDatabase(statusTracker, databases);
        return new StatefulRedisMultiDbPubSubConnectionImpl(databases, this.getResources(), codec, this.getOptions().getJsonParser(), this::createRedisDatabaseWithPubSub, healthStatusManager);
    }

    private <K, V> RedisDatabase<StatefulRedisPubSubConnection<K, V>> createRedisDatabaseWithPubSub(DatabaseConfig config, RedisCodec<K, V> codec, HealthStatusManager healthStatusManager) {
        RedisURI uri = config.getRedisURI();
        StatefulRedisPubSubConnection<K, V> connection = this.connectPubSub(codec, uri);
        DatabaseEndpoint databaseEndpoint = this.extractDatabaseEndpoint(connection);
        CircuitBreakerImpl circuitBreaker = new CircuitBreakerImpl(config.getCircuitBreakerConfig());
        databaseEndpoint.bind(circuitBreaker);
        HealthCheck healthCheck = null;
        if (HealthCheckStrategySupplier.NO_HEALTH_CHECK != config.getHealthCheckStrategySupplier()) {
            HealthCheckStrategy hcStrategy = config.getHealthCheckStrategySupplier().get(config.getRedisURI(), this.databaseRawConnectionFactory);
            healthCheck = healthStatusManager.add(uri, hcStrategy);
        }
        RedisDatabase<StatefulRedisPubSubConnection<K, V>> database = new RedisDatabase<StatefulRedisPubSubConnection<K, V>>(config, connection, databaseEndpoint, circuitBreaker, healthCheck);
        return database;
    }

    private DatabaseEndpoint extractDatabaseEndpoint(StatefulRedisConnection<?, ?> connection) {
        RedisChannelWriter writer = ((StatefulRedisConnectionImpl)connection).getChannelWriter();
        if (writer instanceof Delegating) {
            writer = (RedisChannelWriter)((Delegating)((Object)writer)).unwrap();
        }
        return (DatabaseEndpoint)((Object)writer);
    }

    @Override
    protected DefaultEndpoint createEndpoint() {
        return new DatabaseEndpointImpl(this.getOptions(), this.getResources());
    }

    @Override
    protected <K, V> PubSubEndpoint<K, V> createPubSubEndpoint() {
        return new DatabasePubSubEndpointImpl(this.getOptions(), this.getResources());
    }

    private void waitForInitialHealthyDatabase(StatusTracker statusTracker, Map<RedisURI, ? extends RedisDatabase<?>> databaseMap) {
        List sortedDatabases = databaseMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(db -> Float.valueOf(db.getWeight())).reversed())).collect(Collectors.toList());
        logger.info("Selecting initial database from {} configured databases", (Object)sortedDatabases.size());
        for (Map.Entry entry : sortedDatabases) {
            HealthStatus status;
            RedisURI endpoint = (RedisURI)entry.getKey();
            RedisDatabase database = (RedisDatabase)entry.getValue();
            logger.info("Evaluating database {} (weight: {})", (Object)endpoint, (Object)Float.valueOf(database.getWeight()));
            if (database.getHealthCheck() != null) {
                logger.info("Health checks enabled for {}, waiting for result", (Object)endpoint);
                status = statusTracker.waitForHealthStatus(endpoint);
            } else {
                logger.info("No health check configured for database {}, defaulting to HEALTHY", (Object)endpoint);
                status = HealthStatus.HEALTHY;
            }
            if (status == HealthStatus.HEALTHY) {
                logger.info("Found healthy database: {} (weight: {})", (Object)endpoint, (Object)Float.valueOf(database.getWeight()));
                return;
            }
            logger.info("Database {} is unhealthy, trying next database", (Object)endpoint);
        }
        throw new RedisConnectionException("All configured databases are unhealthy.");
    }

    private class DatabaseRawConnectionFactoryImpl
    implements DatabaseRawConnectionFactory {
        private DatabaseRawConnectionFactoryImpl() {
        }

        @Override
        public StatefulRedisConnection<?, ?> connectToDatabase(RedisURI endpoint) {
            return MultiDbClientImpl.this.connect(endpoint);
        }
    }
}

