/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.CircuitBreakerGeneration;
import io.lettuce.core.failover.DatabaseEndpoint;
import io.lettuce.core.failover.RedisCircuitBreakerException;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;
import java.util.List;

class DatabasePubSubEndpointImpl<K, V>
extends PubSubEndpoint<K, V>
implements DatabaseEndpoint {
    private CircuitBreaker circuitBreaker;

    public DatabasePubSubEndpointImpl(ClientOptions clientOptions, ClientResources clientResources) {
        super(clientOptions, clientResources);
    }

    @Override
    public void bind(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public <K1, V1, T> RedisCommand<K1, V1, T> write(RedisCommand<K1, V1, T> command) {
        RedisCommand<K1, V1, T> result;
        if (this.circuitBreaker == null) {
            return super.write(command);
        }
        if (!this.circuitBreaker.isClosed()) {
            command.completeExceptionally(RedisCircuitBreakerException.INSTANCE);
            return command;
        }
        try {
            result = super.write(command);
        }
        catch (Exception e2) {
            this.circuitBreaker.getGeneration().recordResult(e2);
            throw e2;
        }
        if (result instanceof CompleteableCommand) {
            CircuitBreakerGeneration generation = this.circuitBreaker.getGeneration();
            CompleteableCommand completeable = (CompleteableCommand)((Object)result);
            completeable.onComplete((o, e) -> generation.recordResult((Throwable)e));
        }
        return result;
    }

    @Override
    public <K1, V1> Collection<RedisCommand<K1, V1, ?>> write(Collection<? extends RedisCommand<K1, V1, ?>> commands) {
        Collection result;
        if (this.circuitBreaker == null) {
            return super.write(commands);
        }
        if (!this.circuitBreaker.isClosed()) {
            commands.forEach(c -> c.completeExceptionally(RedisCircuitBreakerException.INSTANCE));
            return commands;
        }
        try {
            result = super.write(commands);
        }
        catch (Exception e2) {
            this.circuitBreaker.getGeneration().recordResult(e2);
            throw e2;
        }
        CircuitBreakerGeneration generation = this.circuitBreaker.getGeneration();
        for (RedisCommand command : result) {
            if (!(command instanceof CompleteableCommand)) continue;
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete((o, e) -> generation.recordResult((Throwable)e));
        }
        return result;
    }

    @Override
    public List<RedisCommand<?, ?, ?>> drainCommands() {
        return super.drainCommands();
    }
}

