/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.CircuitBreaker;
import io.lettuce.core.failover.health.HealthCheckStrategySupplier;
import io.lettuce.core.failover.health.PingStrategy;
import io.lettuce.core.internal.LettuceAssert;

@Experimental
public class DatabaseConfig {
    private static final float DEFAULT_WEIGHT = 1.0f;
    private final RedisURI redisURI;
    private final float weight;
    private final CircuitBreaker.CircuitBreakerConfig circuitBreakerConfig;
    private final HealthCheckStrategySupplier healthCheckStrategySupplier;

    DatabaseConfig(Builder builder) {
        this.redisURI = builder.redisURI;
        this.weight = builder.weight;
        this.circuitBreakerConfig = builder.circuitBreakerConfig != null ? builder.circuitBreakerConfig : CircuitBreaker.CircuitBreakerConfig.DEFAULT;
        this.healthCheckStrategySupplier = builder.healthCheckStrategySupplier;
    }

    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    public float getWeight() {
        return this.weight;
    }

    public CircuitBreaker.CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    public HealthCheckStrategySupplier getHealthCheckStrategySupplier() {
        return this.healthCheckStrategySupplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseConfig)) {
            return false;
        }
        DatabaseConfig that = (DatabaseConfig)o;
        if (Float.compare(that.weight, this.weight) != 0) {
            return false;
        }
        if (!this.redisURI.equals(that.redisURI)) {
            return false;
        }
        if (this.circuitBreakerConfig != null ? !this.circuitBreakerConfig.equals(that.circuitBreakerConfig) : that.circuitBreakerConfig != null) {
            return false;
        }
        return this.healthCheckStrategySupplier.equals(that.healthCheckStrategySupplier);
    }

    public int hashCode() {
        int result = this.redisURI.hashCode();
        result = 31 * result + (this.weight != 0.0f ? Float.floatToIntBits(this.weight) : 0);
        result = 31 * result + (this.circuitBreakerConfig != null ? this.circuitBreakerConfig.hashCode() : 0);
        result = 31 * result + this.healthCheckStrategySupplier.hashCode();
        return result;
    }

    public String toString() {
        return "DatabaseConfig{redisURI=" + this.redisURI + ", weight=" + this.weight + ", circuitBreakerConfig=" + this.circuitBreakerConfig + ", healthCheckStrategySupplier=" + this.healthCheckStrategySupplier + '}';
    }

    public static Builder builder(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        return new Builder(redisURI);
    }

    public Builder mutate() {
        Builder builder = new Builder(this.redisURI);
        builder.weight = this.weight;
        builder.circuitBreakerConfig = this.circuitBreakerConfig;
        builder.healthCheckStrategySupplier = this.healthCheckStrategySupplier;
        return builder;
    }

    public static class Builder {
        private final RedisURI redisURI;
        private float weight = 1.0f;
        private CircuitBreaker.CircuitBreakerConfig circuitBreakerConfig;
        private HealthCheckStrategySupplier healthCheckStrategySupplier = PingStrategy.DEFAULT;

        private Builder(RedisURI redisURI) {
            this.redisURI = redisURI;
        }

        public Builder weight(float weight) {
            LettuceAssert.isTrue(weight > 0.0f, "Weight must be greater than 0");
            this.weight = weight;
            return this;
        }

        public Builder circuitBreakerConfig(CircuitBreaker.CircuitBreakerConfig circuitBreakerConfig) {
            this.circuitBreakerConfig = circuitBreakerConfig;
            return this;
        }

        public Builder healthCheckStrategySupplier(HealthCheckStrategySupplier healthCheckStrategySupplier) {
            LettuceAssert.notNull((Object)healthCheckStrategySupplier, "HealthCheckStrategySupplier must not be null");
            this.healthCheckStrategySupplier = healthCheckStrategySupplier;
            return this;
        }

        public DatabaseConfig build() {
            return new DatabaseConfig(this);
        }
    }
}

