/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.search.HybridReply;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@Experimental
public class HybridReplyParser<K, V>
implements ComplexDataParser<HybridReply<K, V>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(HybridReplyParser.class);
    private final RedisCodec<K, V> codec;
    private final ByteBuffer TOTAL_RESULTS_KEY = StringCodec.UTF8.encodeKey("total_results");
    private final ByteBuffer EXECUTION_TIME_KEY = StringCodec.UTF8.encodeKey("execution_time");
    private final ByteBuffer WARNINGS_KEY = StringCodec.UTF8.encodeKey("warnings");
    private final ByteBuffer RESULTS_KEY = StringCodec.UTF8.encodeKey("results");

    public HybridReplyParser(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    @Override
    public HybridReply<K, V> parse(ComplexData data) {
        try {
            HybridReply hybridReply = new HybridReply();
            if (data.isList()) {
                this.parseResp2(data, hybridReply);
            } else {
                this.parseResp3(data, hybridReply);
            }
            return hybridReply;
        }
        catch (Exception e) {
            LOG.warn("Unable to parse FT.HYBRID result from Redis", (Throwable)e);
            return new HybridReply();
        }
    }

    private void parseResp2(ComplexData data, HybridReply<K, V> reply) {
        List<Object> list = data.getDynamicList();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.parseResp2(list, reply);
    }

    private void parseResp2(List<Object> list, HybridReply<K, V> reply) {
        int i = 0;
        while (i + 1 < list.size()) {
            Object keyObj = list.get(i);
            Object valueObj = list.get(i + 1);
            if (keyObj instanceof ByteBuffer) {
                ComplexData resultsData;
                List<Object> resultsList;
                ByteBuffer keyBuffer = (ByteBuffer)keyObj;
                if (keyBuffer.equals(this.TOTAL_RESULTS_KEY)) {
                    if (valueObj instanceof Long) {
                        reply.setTotalResults((Long)valueObj);
                    }
                } else if (keyBuffer.equals(this.EXECUTION_TIME_KEY)) {
                    if (valueObj instanceof ByteBuffer) {
                        try {
                            String asString = StringCodec.UTF8.decodeKey((ByteBuffer)valueObj);
                            reply.setExecutionTime(Double.parseDouble(asString));
                        }
                        catch (NumberFormatException asString) {}
                    } else if (valueObj instanceof Double) {
                        reply.setExecutionTime((Double)valueObj);
                    }
                } else if (keyBuffer.equals(this.WARNINGS_KEY)) {
                    ComplexData warningData;
                    List<Object> warnList;
                    if (valueObj instanceof ComplexData && (warnList = (warningData = (ComplexData)valueObj).getDynamicList()) != null) {
                        for (Object o : warnList) {
                            if (!(o instanceof ByteBuffer)) continue;
                            reply.addWarning(this.codec.decodeValue((ByteBuffer)o));
                        }
                    }
                } else if (keyBuffer.equals(this.RESULTS_KEY) && valueObj instanceof ComplexData && (resultsList = (resultsData = (ComplexData)valueObj).getDynamicList()) != null) {
                    for (Object resultObj : resultsList) {
                        if (!(resultObj instanceof ComplexData)) continue;
                        HybridReply.Result result = new HybridReply.Result();
                        this.addFieldsFromComplexData((ComplexData)resultObj, result);
                        reply.addResult(result);
                    }
                }
            }
            i += 2;
        }
    }

    private void parseResp3(ComplexData data, HybridReply<K, V> reply) {
        Object resultsObj;
        ComplexData warningData;
        List<Object> warnList;
        Object executionTime;
        Map<Object, Object> resultsMap = data.getDynamicMap();
        if (resultsMap == null || resultsMap.isEmpty()) {
            return;
        }
        Object total = resultsMap.get(this.TOTAL_RESULTS_KEY);
        if (total instanceof Long) {
            reply.setTotalResults((Long)total);
        }
        if ((executionTime = resultsMap.get(this.EXECUTION_TIME_KEY)) instanceof Double) {
            reply.setExecutionTime((Double)executionTime);
        } else if (executionTime instanceof ByteBuffer) {
            try {
                String asString = StringCodec.UTF8.decodeKey((ByteBuffer)executionTime);
                reply.setExecutionTime(Double.parseDouble(asString));
            }
            catch (NumberFormatException asString) {
                // empty catch block
            }
        }
        Object warnings = resultsMap.get(this.WARNINGS_KEY);
        if (warnings instanceof ComplexData && (warnList = (warningData = (ComplexData)warnings).getDynamicList()) != null) {
            for (Object o : warnList) {
                if (!(o instanceof ByteBuffer)) continue;
                reply.addWarning(this.codec.decodeValue((ByteBuffer)o));
            }
        }
        if (!((resultsObj = resultsMap.get(this.RESULTS_KEY)) instanceof ComplexData)) {
            return;
        }
        ComplexData results = (ComplexData)resultsObj;
        List<Object> rawResults = results.getDynamicList();
        if (rawResults == null || rawResults.isEmpty()) {
            return;
        }
        for (Object raw : rawResults) {
            if (!(raw instanceof ComplexData)) continue;
            ComplexData resultData = (ComplexData)raw;
            HybridReply.Result<K, V> result = this.parseResultEntry(resultData);
            reply.addResult(result);
        }
    }

    private HybridReply.Result<K, V> parseResultEntry(ComplexData resultData) {
        Map<Object, Object> entryMap;
        try {
            entryMap = resultData.getDynamicMap();
        }
        catch (UnsupportedOperationException e) {
            entryMap = null;
        }
        HybridReply.Result result = new HybridReply.Result();
        if (entryMap != null && !entryMap.isEmpty()) {
            entryMap.forEach((key, value) -> {
                if (!(key instanceof ByteBuffer) || !(value instanceof ByteBuffer)) {
                    return;
                }
                K fieldKey = this.codec.decodeKey((ByteBuffer)key);
                V fieldValue = this.codec.decodeValue((ByteBuffer)value);
                result.addField(fieldKey, fieldValue);
            });
        } else {
            this.addFieldsFromComplexData(resultData, result);
        }
        return result;
    }

    private void addFieldsFromComplexData(ComplexData data, HybridReply.Result<K, V> result) {
        Map<Object, Object> map;
        try {
            map = data.getDynamicMap();
        }
        catch (UnsupportedOperationException e) {
            map = null;
        }
        if (map != null && !map.isEmpty()) {
            map.forEach((k, v) -> {
                if (!(k instanceof ByteBuffer) || !(v instanceof ByteBuffer)) {
                    return;
                }
                K decodedKey = this.codec.decodeKey((ByteBuffer)k);
                V decodedValue = this.codec.decodeValue((ByteBuffer)v);
                result.addField(decodedKey, decodedValue);
            });
            return;
        }
        List<Object> list = data.getDynamicList();
        if (list == null || list.isEmpty()) {
            return;
        }
        int i = 0;
        while (i + 1 < list.size()) {
            Object k2 = list.get(i);
            Object v2 = list.get(i + 1);
            if (k2 instanceof ByteBuffer && v2 instanceof ByteBuffer) {
                K decodedKey = this.codec.decodeKey((ByteBuffer)k2);
                V decodedValue = this.codec.decodeValue((ByteBuffer)v2);
                result.addField(decodedKey, decodedValue);
            }
            i += 2;
        }
    }
}

