/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.ComplexOutput;
import io.lettuce.core.output.EncodedComplexOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.search.AggregateReplyParser;
import io.lettuce.core.search.AggregationReply;
import io.lettuce.core.search.HybridReply;
import io.lettuce.core.search.HybridReplyParser;
import io.lettuce.core.search.SearchReply;
import io.lettuce.core.search.SearchReplyParser;
import io.lettuce.core.search.SpellCheckResult;
import io.lettuce.core.search.SpellCheckResultParser;
import io.lettuce.core.search.Suggestion;
import io.lettuce.core.search.SuggestionParser;
import io.lettuce.core.search.SynonymMapParser;
import io.lettuce.core.search.arguments.AggregateArgs;
import io.lettuce.core.search.arguments.CreateArgs;
import io.lettuce.core.search.arguments.ExplainArgs;
import io.lettuce.core.search.arguments.FieldArgs;
import io.lettuce.core.search.arguments.HybridArgs;
import io.lettuce.core.search.arguments.SearchArgs;
import io.lettuce.core.search.arguments.SpellCheckArgs;
import io.lettuce.core.search.arguments.SugAddArgs;
import io.lettuce.core.search.arguments.SugGetArgs;
import io.lettuce.core.search.arguments.SynUpdateArgs;
import java.util.List;
import java.util.Map;

class RediSearchCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    RediSearchCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    public Command<K, V, String> ftCreate(String index, CreateArgs<K, V> createArgs, List<FieldArgs<K>> fieldArgs) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        RediSearchCommandBuilder.notEmpty(fieldArgs.toArray());
        CommandArgs args = new CommandArgs(this.codec).add(index);
        if (createArgs != null) {
            createArgs.build(args);
        }
        args.add(CommandKeyword.SCHEMA);
        for (FieldArgs arg : fieldArgs) {
            arg.build(args);
        }
        return this.createCommand(CommandType.FT_CREATE, new StatusOutput(this.codec), args);
    }

    public Command<K, V, SearchReply<K, V>> ftSearch(String index, V query, SearchArgs<K, V> searchArgs) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(query, "Query must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(index);
        args.addValue(query);
        if (searchArgs != null) {
            searchArgs.build(args);
        }
        return this.createCommand(CommandType.FT_SEARCH, new EncodedComplexOutput(this.codec, new SearchReplyParser<K, V>(this.codec, searchArgs)), args);
    }

    public Command<K, V, HybridReply<K, V>> ftHybrid(String index, HybridArgs<K, V> hybridArgs) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(hybridArgs, "HybridArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(index);
        hybridArgs.build(args);
        return this.createCommand(CommandType.FT_HYBRID, new EncodedComplexOutput(this.codec, new HybridReplyParser(this.codec)), args);
    }

    public Command<K, V, AggregationReply<K, V>> ftAggregate(String index, V query, AggregateArgs<K, V> aggregateArgs) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(query, "Query must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(index);
        args.addValue(query);
        boolean withCursor = false;
        if (aggregateArgs != null) {
            aggregateArgs.build(args);
            withCursor = aggregateArgs.getWithCursor() != null && aggregateArgs.getWithCursor().isPresent();
        }
        return this.createCommand(CommandType.FT_AGGREGATE, new EncodedComplexOutput(this.codec, new AggregateReplyParser(this.codec, withCursor)), args);
    }

    public Command<K, V, AggregationReply<K, V>> ftCursorread(String index, long cursorId, int count) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.READ).add(index);
        args.add(cursorId);
        if (count >= 0) {
            args.add(CommandKeyword.COUNT);
            args.add(count);
        }
        return this.createCommand(CommandType.FT_CURSOR, new EncodedComplexOutput(this.codec, new AggregateReplyParser(this.codec, true)), args);
    }

    public Command<K, V, String> ftCursordel(String index, long cursorId) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.DEL).add(index);
        args.add(cursorId);
        return this.createCommand(CommandType.FT_CURSOR, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ftAliasadd(String alias, String index) {
        LettuceAssert.notNull((Object)alias, "Alias must not be null");
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(alias).add(index);
        return this.createCommand(CommandType.FT_ALIASADD, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ftAliasupdate(String alias, String index) {
        LettuceAssert.notNull((Object)alias, "Alias must not be null");
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(alias).add(index);
        return this.createCommand(CommandType.FT_ALIASUPDATE, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ftAliasdel(String alias) {
        LettuceAssert.notNull((Object)alias, "Alias must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(alias);
        return this.createCommand(CommandType.FT_ALIASDEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ftAlter(String index, boolean skipInitialScan, List<FieldArgs<K>> fieldArgs) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        RediSearchCommandBuilder.notEmpty(fieldArgs.toArray());
        CommandArgs args = new CommandArgs(this.codec).add(index);
        if (skipInitialScan) {
            args.add(CommandKeyword.SKIPINITIALSCAN);
        }
        args.add(CommandKeyword.SCHEMA);
        args.add(CommandKeyword.ADD);
        for (FieldArgs arg : fieldArgs) {
            arg.build(args);
        }
        return this.createCommand(CommandType.FT_ALTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<V>> ftTagvals(String index, String fieldName) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull((Object)fieldName, "Field name must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(index).add(fieldName);
        return this.createCommand(CommandType.FT_TAGVALS, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, SpellCheckResult<V>> ftSpellcheck(String index, V query) {
        return this.ftSpellcheck(index, query, null);
    }

    public Command<K, V, SpellCheckResult<V>> ftSpellcheck(String index, V query, SpellCheckArgs<K, V> args) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(query, "Query must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(index).addValue(query);
        if (args != null) {
            args.build(commandArgs);
        }
        SpellCheckResultParser parser = new SpellCheckResultParser(this.codec);
        return this.createCommand(CommandType.FT_SPELLCHECK, new EncodedComplexOutput(this.codec, parser), commandArgs);
    }

    @SafeVarargs
    public final Command<K, V, Long> ftDictadd(String dict, V ... terms) {
        LettuceAssert.notNull((Object)dict, "Dictionary must not be null");
        LettuceAssert.notNull(terms, "Terms must not be null");
        LettuceAssert.isTrue(terms.length > 0, "At least one term must be provided");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(dict);
        for (V term : terms) {
            LettuceAssert.notNull(term, "Term must not be null");
            commandArgs.addValue(term);
        }
        return this.createCommand(CommandType.FT_DICTADD, new IntegerOutput(this.codec), commandArgs);
    }

    @SafeVarargs
    public final Command<K, V, Long> ftDictdel(String dict, V ... terms) {
        LettuceAssert.notNull((Object)dict, "Dictionary must not be null");
        LettuceAssert.notNull(terms, "Terms must not be null");
        LettuceAssert.isTrue(terms.length > 0, "At least one term must be provided");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(dict);
        for (V term : terms) {
            LettuceAssert.notNull(term, "Term must not be null");
            commandArgs.addValue(term);
        }
        return this.createCommand(CommandType.FT_DICTDEL, new IntegerOutput(this.codec), commandArgs);
    }

    public Command<K, V, List<V>> ftDictdump(String dict) {
        LettuceAssert.notNull((Object)dict, "Dictionary name must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(dict);
        return this.createCommand(CommandType.FT_DICTDUMP, new ValueListOutput(this.codec), commandArgs);
    }

    public Command<K, V, String> ftExplain(String index, V query) {
        return this.ftExplain(index, query, null);
    }

    public Command<K, V, String> ftExplain(String index, V query, ExplainArgs<K, V> args) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(query, "Query must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(index).addValue(query);
        if (args != null) {
            args.build(commandArgs);
        }
        return this.createCommand(CommandType.FT_EXPLAIN, new StatusOutput(this.codec), commandArgs);
    }

    public Command<K, V, List<V>> ftList() {
        CommandArgs commandArgs = new CommandArgs(this.codec);
        return this.createCommand(CommandType.FT_LIST, new ValueListOutput(this.codec), commandArgs);
    }

    public Command<K, V, Map<V, List<V>>> ftSyndump(String index) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(index);
        return this.createCommand(CommandType.FT_SYNDUMP, new EncodedComplexOutput(this.codec, new SynonymMapParser(this.codec)), commandArgs);
    }

    @SafeVarargs
    public final Command<K, V, String> ftSynupdate(String index, V synonymGroupId, V ... terms) {
        return this.ftSynupdate(index, synonymGroupId, null, terms);
    }

    @SafeVarargs
    public final Command<K, V, String> ftSynupdate(String index, V synonymGroupId, SynUpdateArgs<K, V> args, V ... terms) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        LettuceAssert.notNull(synonymGroupId, "Synonym group ID must not be null");
        LettuceAssert.notNull(terms, "Terms must not be null");
        LettuceAssert.isTrue(terms.length > 0, "At least one term must be provided");
        CommandArgs commandArgs = new CommandArgs(this.codec).add(index).addValue(synonymGroupId);
        if (args != null) {
            args.build(commandArgs);
        }
        for (V term : terms) {
            LettuceAssert.notNull(term, "Term must not be null");
            commandArgs.addValue(term);
        }
        return this.createCommand(CommandType.FT_SYNUPDATE, new StatusOutput(this.codec), commandArgs);
    }

    public Command<K, V, Long> ftSugadd(K key, V string, double score) {
        return this.ftSugadd(key, string, score, null);
    }

    public Command<K, V, Long> ftSugadd(K key, V string, double score, SugAddArgs<K, V> args) {
        RediSearchCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(string, "String must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).addKey(key).addValue(string).add(score);
        if (args != null) {
            args.build(commandArgs);
        }
        return this.createCommand(CommandType.FT_SUGADD, new IntegerOutput(this.codec), commandArgs);
    }

    public Command<K, V, Boolean> ftSugdel(K key, V string) {
        RediSearchCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(string, "String must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).addKey(key).addValue(string);
        return this.createCommand(CommandType.FT_SUGDEL, new BooleanOutput(this.codec), commandArgs);
    }

    public Command<K, V, List<Suggestion<V>>> ftSugget(K key, V prefix) {
        return this.ftSugget(key, prefix, null);
    }

    public Command<K, V, List<Suggestion<V>>> ftSugget(K key, V prefix, SugGetArgs<K, V> args) {
        RediSearchCommandBuilder.notNullKey(key);
        LettuceAssert.notNull(prefix, "Prefix must not be null");
        CommandArgs commandArgs = new CommandArgs(this.codec).addKey(key).addValue(prefix);
        boolean withScores = false;
        boolean withPayloads = false;
        if (args != null) {
            withScores = args.isWithScores();
            withPayloads = args.isWithPayloads();
            args.build(commandArgs);
        }
        SuggestionParser parser = new SuggestionParser(withScores, withPayloads);
        return this.createCommand(CommandType.FT_SUGGET, new ComplexOutput(this.codec, parser), commandArgs);
    }

    public Command<K, V, Long> ftSuglen(K key) {
        RediSearchCommandBuilder.notNullKey(key);
        CommandArgs commandArgs = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.FT_SUGLEN, new IntegerOutput(this.codec), commandArgs);
    }

    public Command<K, V, String> ftDropindex(String index, boolean deleteDocumentKeys) {
        LettuceAssert.notNull((Object)index, "Index must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(index);
        if (deleteDocumentKeys) {
            args.add(CommandKeyword.DD);
        }
        return this.createCommand(CommandType.FT_DROPINDEX, new StatusOutput(this.codec), args);
    }
}

