/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.MaintNotificationsConfig;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.RedisJsonException;
import io.lettuce.core.protocol.DecodeBufferPolicies;
import io.lettuce.core.protocol.DecodeBufferPolicy;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.ReadOnlyCommands;
import io.lettuce.core.protocol.RedisCommand;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ClientOptions
implements Serializable {
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final MaintNotificationsConfig DEFAULT_MAINT_NOTIFICATIONS_CONFIG = MaintNotificationsConfig.enabled();
    public static final Predicate<RedisCommand<?, ?, ?>> DEFAULT_REPLAY_FILTER = cmd -> false;
    public static final int DEFAULT_BUFFER_USAGE_RATIO = 3;
    public static final DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = DisconnectedBehavior.DEFAULT;
    public static final ReauthenticateBehavior DEFAULT_REAUTHENTICATE_BEHAVIOUR = ReauthenticateBehavior.DEFAULT;
    public static final boolean DEFAULT_PUBLISH_ON_SCHEDULER = false;
    public static final boolean DEFAULT_PING_BEFORE_ACTIVATE_CONNECTION = true;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION = ProtocolVersion.newestSupported();
    public static final ReadOnlyCommands.ReadOnlyPredicate DEFAULT_READ_ONLY_COMMANDS = ReadOnlyCommands.asPredicate();
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final Charset DEFAULT_SCRIPT_CHARSET = StandardCharsets.UTF_8;
    public static final SocketOptions DEFAULT_SOCKET_OPTIONS = SocketOptions.create();
    public static final Supplier<JsonParser> DEFAULT_JSON_PARSER = () -> {
        try {
            Iterator<JsonParser> services = ServiceLoader.load(JsonParser.class).iterator();
            return services.hasNext() ? services.next() : null;
        }
        catch (ServiceConfigurationError e) {
            throw new RedisJsonException("Could not load JsonParser, please consult the guideat https://redis.github.io/lettuce/user-guide/redis-json/", e);
        }
    };
    public static final SslOptions DEFAULT_SSL_OPTIONS = SslOptions.create();
    public static final boolean DEFAULT_SUSPEND_RECONNECT_PROTO_FAIL = false;
    public static final TimeoutOptions DEFAULT_TIMEOUT_OPTIONS = TimeoutOptions.enabled();
    public static final boolean DEFAULT_USE_HASH_INDEX_QUEUE = true;
    private final boolean autoReconnect;
    private final MaintNotificationsConfig maintNotificationsConfig;
    private final Predicate<RedisCommand<?, ?, ?>> replayFilter;
    private final DecodeBufferPolicy decodeBufferPolicy;
    private final DisconnectedBehavior disconnectedBehavior;
    private final ReauthenticateBehavior reauthenticateBehavior;
    private final boolean publishOnScheduler;
    private final boolean pingBeforeActivateConnection;
    private final ProtocolVersion protocolVersion;
    private final ReadOnlyCommands.ReadOnlyPredicate readOnlyCommands;
    private final int requestQueueSize;
    private final Charset scriptCharset;
    private final Supplier<JsonParser> jsonParser;
    private final SocketOptions socketOptions;
    private final SslOptions sslOptions;
    private final boolean suspendReconnectOnProtocolFailure;
    private final TimeoutOptions timeoutOptions;
    private final boolean useHashIndexedQueue;

    protected ClientOptions(Builder builder) {
        this.autoReconnect = builder.autoReconnect;
        this.maintNotificationsConfig = builder.maintNotificationsConfig;
        this.replayFilter = builder.replayFilter;
        this.decodeBufferPolicy = builder.decodeBufferPolicy;
        this.disconnectedBehavior = builder.disconnectedBehavior;
        this.reauthenticateBehavior = builder.reauthenticateBehavior;
        this.publishOnScheduler = builder.publishOnScheduler;
        this.pingBeforeActivateConnection = builder.pingBeforeActivateConnection;
        this.protocolVersion = builder.protocolVersion;
        this.readOnlyCommands = builder.readOnlyCommands;
        this.requestQueueSize = builder.requestQueueSize;
        this.scriptCharset = builder.scriptCharset;
        this.jsonParser = builder.jsonParser;
        this.socketOptions = builder.socketOptions;
        this.sslOptions = builder.sslOptions;
        this.suspendReconnectOnProtocolFailure = builder.suspendReconnectOnProtocolFailure;
        this.timeoutOptions = builder.timeoutOptions;
        this.useHashIndexedQueue = builder.useHashIndexedQueue;
    }

    protected ClientOptions(ClientOptions original) {
        this.autoReconnect = original.isAutoReconnect();
        this.maintNotificationsConfig = original.getMaintNotificationsConfig();
        this.replayFilter = original.getReplayFilter();
        this.decodeBufferPolicy = original.getDecodeBufferPolicy();
        this.disconnectedBehavior = original.getDisconnectedBehavior();
        this.reauthenticateBehavior = original.getReauthenticateBehaviour();
        this.publishOnScheduler = original.isPublishOnScheduler();
        this.pingBeforeActivateConnection = original.isPingBeforeActivateConnection();
        this.protocolVersion = original.getConfiguredProtocolVersion();
        this.readOnlyCommands = original.getReadOnlyCommands();
        this.requestQueueSize = original.getRequestQueueSize();
        this.scriptCharset = original.getScriptCharset();
        this.jsonParser = original.getJsonParser();
        this.socketOptions = original.getSocketOptions();
        this.sslOptions = original.getSslOptions();
        this.suspendReconnectOnProtocolFailure = original.isSuspendReconnectOnProtocolFailure();
        this.timeoutOptions = original.getTimeoutOptions();
        this.useHashIndexedQueue = original.isUseHashIndexedQueue();
    }

    public static ClientOptions copyOf(ClientOptions options) {
        return new ClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClientOptions create() {
        return ClientOptions.builder().build();
    }

    public Builder mutate() {
        Builder builder = new Builder();
        builder.autoReconnect(this.isAutoReconnect()).maintNotificationsConfig(this.getMaintNotificationsConfig()).replayFilter(this.getReplayFilter()).decodeBufferPolicy(this.getDecodeBufferPolicy()).disconnectedBehavior(this.getDisconnectedBehavior()).reauthenticateBehavior(this.getReauthenticateBehaviour()).readOnlyCommands(this.getReadOnlyCommands()).publishOnScheduler(this.isPublishOnScheduler()).pingBeforeActivateConnection(this.isPingBeforeActivateConnection()).protocolVersion(this.getConfiguredProtocolVersion()).requestQueueSize(this.getRequestQueueSize()).scriptCharset(this.getScriptCharset()).jsonParser(this.getJsonParser()).socketOptions(this.getSocketOptions()).sslOptions(this.getSslOptions()).suspendReconnectOnProtocolFailure(this.isSuspendReconnectOnProtocolFailure()).timeoutOptions(this.getTimeoutOptions());
        return builder;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public MaintNotificationsConfig getMaintNotificationsConfig() {
        return this.maintNotificationsConfig;
    }

    public Predicate<RedisCommand<?, ?, ?>> getReplayFilter() {
        return this.replayFilter;
    }

    public DecodeBufferPolicy getDecodeBufferPolicy() {
        return this.decodeBufferPolicy;
    }

    public DisconnectedBehavior getDisconnectedBehavior() {
        return this.disconnectedBehavior;
    }

    public ReauthenticateBehavior getReauthenticateBehaviour() {
        return this.reauthenticateBehavior;
    }

    public ReadOnlyCommands.ReadOnlyPredicate getReadOnlyCommands() {
        return this.readOnlyCommands;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public ProtocolVersion getProtocolVersion() {
        ProtocolVersion protocolVersion = this.getConfiguredProtocolVersion();
        return protocolVersion == null ? DEFAULT_PROTOCOL_VERSION : protocolVersion;
    }

    public ProtocolVersion getConfiguredProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isPublishOnScheduler() {
        return this.publishOnScheduler;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public Charset getScriptCharset() {
        return this.scriptCharset;
    }

    public Supplier<JsonParser> getJsonParser() {
        return this.jsonParser;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    public TimeoutOptions getTimeoutOptions() {
        return this.timeoutOptions;
    }

    public boolean isUseHashIndexedQueue() {
        return this.useHashIndexedQueue;
    }

    public static enum DisconnectedBehavior {
        DEFAULT,
        ACCEPT_COMMANDS,
        REJECT_COMMANDS;

    }

    public static enum ReauthenticateBehavior {
        DEFAULT,
        ON_NEW_CREDENTIALS;

    }

    public static class Builder {
        private boolean autoReconnect = true;
        private MaintNotificationsConfig maintNotificationsConfig = DEFAULT_MAINT_NOTIFICATIONS_CONFIG;
        private Predicate<RedisCommand<?, ?, ?>> replayFilter = DEFAULT_REPLAY_FILTER;
        private DecodeBufferPolicy decodeBufferPolicy = DecodeBufferPolicies.ratio(3.0f);
        private DisconnectedBehavior disconnectedBehavior = DEFAULT_DISCONNECTED_BEHAVIOR;
        private boolean pingBeforeActivateConnection = true;
        private ProtocolVersion protocolVersion;
        private boolean publishOnScheduler = false;
        private ReadOnlyCommands.ReadOnlyPredicate readOnlyCommands = DEFAULT_READ_ONLY_COMMANDS;
        private int requestQueueSize = Integer.MAX_VALUE;
        private Charset scriptCharset = DEFAULT_SCRIPT_CHARSET;
        private Supplier<JsonParser> jsonParser = DEFAULT_JSON_PARSER;
        private SocketOptions socketOptions = DEFAULT_SOCKET_OPTIONS;
        private SslOptions sslOptions = DEFAULT_SSL_OPTIONS;
        private boolean suspendReconnectOnProtocolFailure = false;
        private TimeoutOptions timeoutOptions = DEFAULT_TIMEOUT_OPTIONS;
        private ReauthenticateBehavior reauthenticateBehavior = DEFAULT_REAUTHENTICATE_BEHAVIOUR;
        private boolean useHashIndexedQueue = true;

        protected Builder() {
        }

        public Builder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder maintNotificationsConfig(MaintNotificationsConfig maintNotificationsConfig) {
            this.maintNotificationsConfig = maintNotificationsConfig;
            return this;
        }

        public Builder replayFilter(Predicate<RedisCommand<?, ?, ?>> replayFilter) {
            this.replayFilter = replayFilter;
            return this;
        }

        public Builder decodeBufferPolicy(DecodeBufferPolicy policy) {
            LettuceAssert.notNull((Object)policy, "DecodeBufferPolicy must not be null");
            this.decodeBufferPolicy = policy;
            return this;
        }

        public Builder disconnectedBehavior(DisconnectedBehavior disconnectedBehavior) {
            LettuceAssert.notNull((Object)disconnectedBehavior, "DisconnectedBehavior must not be null");
            this.disconnectedBehavior = disconnectedBehavior;
            return this;
        }

        public Builder reauthenticateBehavior(ReauthenticateBehavior reauthenticateBehavior) {
            LettuceAssert.notNull((Object)reauthenticateBehavior, "ReuthenticatBehavior must not be null");
            this.reauthenticateBehavior = reauthenticateBehavior;
            return this;
        }

        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            this.pingBeforeActivateConnection = pingBeforeActivateConnection;
            return this;
        }

        public Builder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder publishOnScheduler(boolean publishOnScheduler) {
            this.publishOnScheduler = publishOnScheduler;
            return this;
        }

        public Builder readOnlyCommands(ReadOnlyCommands.ReadOnlyPredicate readOnlyCommands) {
            LettuceAssert.notNull((Object)readOnlyCommands, "readOnlyCommands must not be null");
            this.readOnlyCommands = readOnlyCommands;
            return this;
        }

        public Builder requestQueueSize(int requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public Builder scriptCharset(Charset scriptCharset) {
            LettuceAssert.notNull((Object)scriptCharset, "ScriptCharset must not be null");
            this.scriptCharset = scriptCharset;
            return this;
        }

        public Builder jsonParser(Supplier<JsonParser> parser) {
            LettuceAssert.notNull(parser, "JsonParser must not be null");
            this.jsonParser = parser;
            return this;
        }

        public Builder socketOptions(SocketOptions socketOptions) {
            LettuceAssert.notNull((Object)socketOptions, "SocketOptions must not be null");
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder sslOptions(SslOptions sslOptions) {
            LettuceAssert.notNull((Object)sslOptions, "SslOptions must not be null");
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
            return this;
        }

        public Builder timeoutOptions(TimeoutOptions timeoutOptions) {
            LettuceAssert.notNull((Object)timeoutOptions, "TimeoutOptions must not be null");
            this.timeoutOptions = timeoutOptions;
            return this;
        }

        public Builder useHashIndexQueue(boolean useHashIndexedQueue) {
            this.useHashIndexedQueue = useHashIndexedQueue;
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

