/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SummarizeArgs<K, V> {
    private final List<K> fields = new ArrayList<K>();
    private Optional<Long> frags = Optional.empty();
    private Optional<Long> len = Optional.empty();
    private Optional<V> separator = Optional.empty();

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, V> args) {
        args.add(CommandKeyword.SUMMARIZE);
        if (!this.fields.isEmpty()) {
            args.add(CommandKeyword.FIELDS);
            args.add(this.fields.size());
            args.addKeys((Iterable<K>)this.fields);
        }
        this.frags.ifPresent(f -> {
            args.add(CommandKeyword.FRAGS);
            args.add((long)f);
        });
        this.len.ifPresent(l -> {
            args.add(CommandKeyword.LEN);
            args.add((long)l);
        });
        this.separator.ifPresent(s -> {
            args.add(CommandKeyword.SEPARATOR);
            args.addValue(s);
        });
    }

    public static class Builder<K, V> {
        private final SummarizeArgs<K, V> summarizeArgs = new SummarizeArgs();

        public Builder<K, V> field(K field) {
            ((SummarizeArgs)this.summarizeArgs).fields.add(field);
            return this;
        }

        public Builder<K, V> fragments(long frags) {
            ((SummarizeArgs)this.summarizeArgs).frags = Optional.of(frags);
            return this;
        }

        public Builder<K, V> len(long len) {
            ((SummarizeArgs)this.summarizeArgs).len = Optional.of(len);
            return this;
        }

        public Builder<K, V> separator(V separator) {
            ((SummarizeArgs)this.summarizeArgs).separator = Optional.of(separator);
            return this;
        }

        public SummarizeArgs<K, V> build() {
            return this.summarizeArgs;
        }
    }
}

