/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.VAddArgs;
import io.lettuce.core.VSimArgs;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.ComplexOutput;
import io.lettuce.core.output.DoubleListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.JsonValueListOutput;
import io.lettuce.core.output.RawVectorParser;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.VSimScoreAttribsMapOutput;
import io.lettuce.core.output.ValueDoubleMapOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.output.VectorMetadataParser;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.vector.RawVector;
import io.lettuce.core.vector.VSimScoreAttribs;
import io.lettuce.core.vector.VectorMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class RedisVectorSetCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    private final Supplier<JsonParser> parser;

    public RedisVectorSetCommandBuilder(RedisCodec<K, V> codec, Supplier<JsonParser> parser) {
        super(codec);
        this.parser = parser;
    }

    public Command<K, V, Boolean> vadd(K key, V element, Double[] vectors) {
        return this.vadd(key, -1, element, null, vectors);
    }

    public Command<K, V, Boolean> vadd(K key, int dimensionality, V element, Double[] vectors) {
        return this.vadd(key, dimensionality, element, null, vectors);
    }

    public Command<K, V, Boolean> vadd(K key, V element, VAddArgs vAddArgs, Double[] vectors) {
        return this.vadd(key, -1, element, vAddArgs, vectors);
    }

    public Command<K, V, Boolean> vadd(K key, int dimensionality, V element, VAddArgs vAddArgs, Double[] vectors) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        RedisVectorSetCommandBuilder.notEmpty(vectors);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (dimensionality > 0) {
            args.add(CommandKeyword.REDUCE);
            args.add(dimensionality);
        }
        if (vectors.length > 1) {
            args.add(CommandKeyword.VALUES);
            args.add(vectors.length);
            Arrays.stream(vectors).map(Object::toString).forEach(args::add);
        } else {
            args.add(vectors[0]);
        }
        args.addValue(element);
        if (vAddArgs != null) {
            vAddArgs.build(args);
        }
        return this.createCommand(CommandType.VADD, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Long> vcard(K key) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        return this.createCommand(CommandType.VCARD, new IntegerOutput(this.codec), new CommandArgs(this.codec).addKey(key));
    }

    public Command<K, V, Long> vdim(K key) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.VDIM, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<Double>> vemb(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element);
        return this.createCommand(CommandType.VEMB, new DoubleListOutput(this.codec), args);
    }

    public Command<K, V, RawVector> vembRaw(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element).add(CommandKeyword.RAW);
        return this.createCommand(CommandType.VEMB, new ComplexOutput(this.codec, RawVectorParser.INSTANCE), args);
    }

    public Command<K, V, String> vgetattr(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element);
        return this.createCommand(CommandType.VGETATTR, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<JsonValue>> vgetattrAsJsonValue(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element);
        return this.createCommand(CommandType.VGETATTR, new JsonValueListOutput(this.codec, this.parser.get()), args);
    }

    public Command<K, V, VectorMetadata> vinfo(K key) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.VINFO, new ComplexOutput(this.codec, VectorMetadataParser.INSTANCE), args);
    }

    public Command<K, V, List<V>> vlinks(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element);
        return this.createCommand(CommandType.VLINKS, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Map<V, Double>> vlinksWithScores(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.VLINKS, new ValueDoubleMapOutput(this.codec), args);
    }

    public Command<K, V, V> vrandmember(K key) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.VRANDMEMBER, new ValueOutput(this.codec), args);
    }

    public Command<K, V, List<V>> vrandmember(K key, int count) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.VRANDMEMBER, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Boolean> vrem(K key, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element);
        return this.createCommand(CommandType.VREM, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Boolean> vsetattr(K key, V element, String json) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        RedisVectorSetCommandBuilder.notNullKey(json);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element).add(json);
        return this.createCommand(CommandType.VSETATTR, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Boolean> vsetattr(K key, V element, JsonValue json) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        RedisVectorSetCommandBuilder.notNullKey(json);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(element).add(json.toString());
        return this.createCommand(CommandType.VSETATTR, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, List<V>> vsim(K key, Double[] vectors) {
        return this.vsim(key, null, (V)vectors);
    }

    public Command<K, V, List<V>> vsim(K key, V element) {
        return this.vsim(key, null, element);
    }

    public Command<K, V, List<V>> vsim(K key, VSimArgs vSimArgs, Double[] vectors) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notEmpty(vectors);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (vectors.length > 1) {
            args.add(CommandKeyword.VALUES);
            args.add(vectors.length);
            Arrays.stream(vectors).forEach(args::add);
        } else {
            args.add(vectors[0]);
        }
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> vsim(K key, VSimArgs vSimArgs, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(CommandKeyword.ELE).addValue(element);
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Map<V, Double>> vsimWithScore(K key, Double[] vectors) {
        return this.vsimWithScore(key, null, (V)vectors);
    }

    public Command<K, V, Map<V, Double>> vsimWithScore(K key, V element) {
        return this.vsimWithScore(key, null, element);
    }

    public Command<K, V, Map<V, Double>> vsimWithScore(K key, VSimArgs vSimArgs, Double[] vectors) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notEmpty(vectors);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (vectors.length > 1) {
            args.add(CommandKeyword.VALUES);
            args.add(vectors.length);
            Arrays.stream(vectors).forEach(args::add);
        } else {
            args.add(vectors[0]);
        }
        args.add(CommandKeyword.WITHSCORES);
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new ValueDoubleMapOutput(this.codec), args);
    }

    public Command<K, V, Map<V, Double>> vsimWithScore(K key, VSimArgs vSimArgs, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(CommandKeyword.ELE).addValue(element).add(CommandKeyword.WITHSCORES);
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new ValueDoubleMapOutput(this.codec), args);
    }

    public Command<K, V, Map<V, VSimScoreAttribs>> vsimWithScoreWithAttribs(K key, Double[] vectors) {
        return this.vsimWithScoreWithAttribs(key, null, (V)vectors);
    }

    public Command<K, V, Map<V, VSimScoreAttribs>> vsimWithScoreWithAttribs(K key, V element) {
        return this.vsimWithScoreWithAttribs(key, null, element);
    }

    public Command<K, V, Map<V, VSimScoreAttribs>> vsimWithScoreWithAttribs(K key, VSimArgs vSimArgs, Double[] vectors) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notEmpty(vectors);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (vectors.length > 1) {
            args.add(CommandKeyword.VALUES);
            args.add(vectors.length);
            Arrays.stream(vectors).forEach(args::add);
        } else {
            args.add(vectors[0]);
        }
        args.add(CommandKeyword.WITHSCORES).add(CommandKeyword.WITHATTRIBS);
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new VSimScoreAttribsMapOutput(this.codec), args);
    }

    public Command<K, V, Map<V, VSimScoreAttribs>> vsimWithScoreWithAttribs(K key, VSimArgs vSimArgs, V element) {
        RedisVectorSetCommandBuilder.notNullKey(key);
        RedisVectorSetCommandBuilder.notNullKey(element);
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(CommandKeyword.ELE).addValue(element).add(CommandKeyword.WITHSCORES).add(CommandKeyword.WITHATTRIBS);
        if (vSimArgs != null) {
            vSimArgs.build(args);
        }
        return this.createCommand(CommandType.VSIM, new VSimScoreAttribsMapOutput(this.codec), args);
    }
}

