/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class KeyListOutput<K, V>
extends CommandOutput<K, V, List<K>>
implements StreamingOutput<K> {
    private StreamingOutput.Subscriber<K> subscriber;

    public KeyListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber(ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext(this.codec.decodeKey(bytes));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<K> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<K> getSubscriber() {
        return this.subscriber;
    }
}

