/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.StreamingOutput;
import io.lettuce.core.protocol.CommandWrapper;
import io.lettuce.core.protocol.DemandAware;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.Queues;

class RedisPublisher<K, V, T>
implements Publisher<T> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(RedisPublisher.class);
    private final boolean traceEnabled = LOG.isTraceEnabled();
    private final Supplier<? extends RedisCommand<K, V, T>> commandSupplier;
    private final AtomicReference<RedisCommand<K, V, T>> ref;
    private final StatefulConnection<K, V> connection;
    private final boolean dissolve;

    public RedisPublisher(RedisCommand<K, V, T> staticCommand, StatefulConnection<K, V> connection, boolean dissolve) {
        this(() -> staticCommand, connection, dissolve);
    }

    public RedisPublisher(Supplier<RedisCommand<K, V, T>> commandSupplier, StatefulConnection<K, V> connection, boolean dissolve) {
        LettuceAssert.notNull(commandSupplier, "CommandSupplier must not be null");
        LettuceAssert.notNull(connection, "StatefulConnection must not be null");
        this.commandSupplier = commandSupplier;
        this.connection = connection;
        this.dissolve = dissolve;
        this.ref = new AtomicReference<RedisCommand<K, RedisCommand<K, V, T>, T>>(commandSupplier.get());
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        RedisCommand<K, V, T> command;
        if (this.traceEnabled) {
            LOG.trace("subscribe: {}@{}", (Object)subscriber.getClass().getName(), (Object)Objects.hashCode(subscriber));
        }
        if ((command = this.ref.get()) != null) {
            if (!this.ref.compareAndSet(command, null)) {
                command = this.commandSupplier.get();
            }
        } else {
            command = this.commandSupplier.get();
        }
        RedisSubscription<T> redisSubscription = new RedisSubscription<T>(this.connection, command, this.dissolve);
        redisSubscription.subscribe(subscriber);
    }

    private static class CompositeSubscriber<T>
    implements StreamingOutput.Subscriber<T> {
        private final Collection<StreamingOutput.Subscriber<T>> subscribers;

        CompositeSubscriber(Collection<StreamingOutput.Subscriber<T>> subscribers) {
            this.subscribers = subscribers;
        }

        @Override
        public void onNext(T t) {
            this.subscribers.forEach(subscriber -> subscriber.onNext(t));
        }
    }

    private static class SubscriptionCommand<K, V, T>
    extends CommandWrapper<K, V, T>
    implements DemandAware.Sink {
        private final boolean dissolve;
        private final RedisSubscription<T> subscription;
        private volatile boolean completed = false;
        private volatile DemandAware.Source source;

        public SubscriptionCommand(RedisCommand<K, V, T> command, RedisSubscription<T> subscription, boolean dissolve) {
            super(command);
            this.subscription = subscription;
            this.dissolve = dissolve;
        }

        @Override
        public boolean hasDemand() {
            return this.completed || this.subscription.state() == State.COMPLETED || RedisSubscription.DEMAND.get(this.subscription) > (long)this.subscription.data.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            if (this.completed) {
                return;
            }
            try {
                super.complete();
                if (this.getOutput() != null) {
                    Object result = this.getOutput().get();
                    if (this.getOutput().hasError()) {
                        this.onError(new RedisCommandExecutionException(this.getOutput().getError()));
                        this.completed = true;
                        return;
                    }
                    if (!(this.getOutput() instanceof StreamingOutput) && result != null) {
                        if (this.dissolve && result instanceof Collection) {
                            Collection collection = (Collection)result;
                            for (Object t : collection) {
                                if (t == null) continue;
                                this.subscription.onNext(t);
                            }
                        } else {
                            this.subscription.onNext(result);
                        }
                    }
                }
                this.subscription.onAllDataRead();
            }
            finally {
                this.completed = true;
            }
        }

        @Override
        public void setSource(DemandAware.Source source) {
            this.source = source;
        }

        @Override
        public void removeSource() {
            this.source = null;
        }

        @Override
        public void cancel() {
            if (this.completed) {
                return;
            }
            super.cancel();
            this.completed = true;
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            if (this.completed) {
                return false;
            }
            boolean b = super.completeExceptionally(throwable);
            this.onError(throwable);
            this.completed = true;
            return b;
        }

        private void onError(Throwable throwable) {
            this.subscription.onError(throwable);
        }
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            void subscribe(RedisSubscription<?> subscription, Subscriber<?> subscriber) {
                LettuceAssert.notNull(subscriber, "Subscriber must not be null");
                if (!((RedisSubscription)subscription).changeState(this, 1.NO_DEMAND)) {
                    throw new IllegalStateException(this.toString());
                }
                subscription.subscriber = subscriber;
                subscriber.onSubscribe(subscription);
            }
        }
        ,
        NO_DEMAND{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                if (Operators.checkRequest((long)n, subscription.subscriber)) {
                    Operators.getAndAddCap(RedisSubscription.DEMAND, subscription, (long)n);
                    if (((RedisSubscription)subscription).changeState(this, 2.DEMAND)) {
                        try {
                            subscription.checkCommandDispatch();
                        }
                        catch (Exception ex) {
                            subscription.onError(ex);
                        }
                        subscription.checkOnDataAvailable();
                    }
                }
            }
        }
        ,
        DEMAND{

            @Override
            void onDataAvailable(RedisSubscription<?> subscription) {
                if (((RedisSubscription)subscription).changeState(this, 3.READING)) {
                    try {
                        boolean demandAvailable = ((RedisSubscription)subscription).readAndPublish();
                        if (demandAvailable) {
                            ((RedisSubscription)subscription).changeState(3.READING, 3.DEMAND);
                            subscription.checkOnDataAvailable();
                        } else if (subscription.data.isEmpty() && subscription.allDataRead) {
                            subscription.onAllDataRead();
                        } else {
                            ((RedisSubscription)subscription).changeState(3.READING, 3.NO_DEMAND);
                        }
                    }
                    catch (IOException ex) {
                        this.onError(subscription, ex);
                    }
                }
            }

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                if (Operators.checkRequest((long)n, subscription.subscriber)) {
                    Operators.getAndAddCap(RedisSubscription.DEMAND, subscription, (long)n);
                }
            }
        }
        ,
        READING{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                if (Operators.checkRequest((long)n, subscription.subscriber)) {
                    Operators.getAndAddCap(RedisSubscription.DEMAND, subscription, (long)n);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
            }

            @Override
            void cancel(RedisSubscription<?> subscription) {
            }

            @Override
            void onAllDataRead(RedisSubscription<?> subscription) {
            }

            @Override
            void onError(RedisSubscription<?> subscription, Throwable t) {
            }
        };


        void subscribe(RedisSubscription<?> subscription, Subscriber<?> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        void request(RedisSubscription<?> subscription, long n) {
            throw new IllegalStateException(this.toString());
        }

        void cancel(RedisSubscription<?> subscription) {
            subscription.command.cancel();
            if (((RedisSubscription)subscription).changeState(this, State.COMPLETED)) {
                this.readData(subscription);
            }
        }

        void readData(RedisSubscription<?> subscription) {
            DemandAware.Source source = ((RedisSubscription)subscription).subscriptionCommand.source;
            if (source != null) {
                source.requestMore();
            }
        }

        void onDataAvailable(RedisSubscription<?> subscription) {
        }

        void onAllDataRead(RedisSubscription<?> subscription) {
            subscription.allDataRead = true;
            if (subscription.data.isEmpty() && ((RedisSubscription)subscription).changeState(this, State.COMPLETED)) {
                this.readData(subscription);
                if (subscription.subscriber != null) {
                    subscription.subscriber.onComplete();
                }
            }
        }

        void onError(RedisSubscription<?> subscription, Throwable t) {
            if (((RedisSubscription)subscription).changeState(this, State.COMPLETED)) {
                this.readData(subscription);
                if (subscription.subscriber != null) {
                    subscription.subscriber.onError(t);
                }
            }
        }
    }

    private static enum CommandDispatch {
        UNDISPATCHED{

            @Override
            void dispatch(RedisSubscription<?> redisSubscription) {
                if (redisSubscription.commandDispatch.compareAndSet(this, DISPATCHED)) {
                    redisSubscription.dispatchCommand();
                }
            }
        }
        ,
        DISPATCHED;


        void dispatch(RedisSubscription<?> redisSubscription) {
        }
    }

    static class RedisSubscription<T>
    implements Subscription,
    StreamingOutput.Subscriber<T> {
        static final InternalLogger LOG = InternalLoggerFactory.getInstance(RedisPublisher.class);
        static final AtomicLongFieldUpdater<RedisSubscription> DEMAND = AtomicLongFieldUpdater.newUpdater(RedisSubscription.class, "demand");
        private final SubscriptionCommand<?, ?, T> subscriptionCommand;
        private final boolean traceEnabled = LOG.isTraceEnabled();
        final Queue<T> data = (Queue)Queues.unbounded().get();
        final StatefulConnection<?, ?> connection;
        final RedisCommand<?, ?, T> command;
        final boolean dissolve;
        final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
        final AtomicReference<CommandDispatch> commandDispatch = new AtomicReference<CommandDispatch>(CommandDispatch.UNDISPATCHED);
        volatile long demand;
        volatile boolean allDataRead = false;
        Subscriber<? super T> subscriber;

        RedisSubscription(StatefulConnection<?, ?> connection, RedisCommand<?, ?, T> command, boolean dissolve) {
            LettuceAssert.notNull(connection, "Connection must not be null");
            LettuceAssert.notNull(command, "RedisCommand must not be null");
            this.connection = connection;
            this.command = command;
            this.dissolve = dissolve;
            if (command.getOutput() instanceof StreamingOutput) {
                StreamingOutput streamingOutput = (StreamingOutput)((Object)command.getOutput());
                if (connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti()) {
                    streamingOutput.setSubscriber(new CompositeSubscriber(Arrays.asList(this, streamingOutput.getSubscriber())));
                } else {
                    streamingOutput.setSubscriber(this);
                }
            }
            this.subscriptionCommand = new SubscriptionCommand(command, this, dissolve);
        }

        void subscribe(Subscriber<? super T> subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("Subscriber must not be null");
            }
            if (this.traceEnabled) {
                LOG.trace("{} subscribe: {}@{}", new Object[]{this.state(), subscriber.getClass().getName(), subscriber.hashCode()});
            }
            this.state().subscribe(this, subscriber);
        }

        public final void request(long n) {
            if (this.traceEnabled) {
                LOG.trace("{} request: {}", (Object)this.state(), (Object)n);
            }
            this.state().request(this, n);
        }

        public final void cancel() {
            if (this.traceEnabled) {
                LOG.trace("{} cancel", (Object)this.state());
            }
            this.state().cancel(this);
        }

        @Override
        public void onNext(T t) {
            LettuceAssert.notNull(t, "Data must not be null");
            if (this.state() == State.COMPLETED) {
                return;
            }
            if (!this.data.offer(t)) {
                Throwable e = Operators.onOperatorError((Subscription)this, (Throwable)Exceptions.failWithOverflow(), t);
                this.onError(e);
                return;
            }
            this.onDataAvailable();
        }

        final void onDataAvailable() {
            if (this.traceEnabled) {
                LOG.trace("{} onDataAvailable()", (Object)this.state());
            }
            this.state().onDataAvailable(this);
        }

        final void onAllDataRead() {
            if (this.traceEnabled) {
                LOG.trace("{} onAllDataRead()", (Object)this.state());
            }
            this.state().onAllDataRead(this);
        }

        final void onError(Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.trace("{} onError(): {}", new Object[]{this.state(), t.toString(), t});
            }
            this.state().onError(this, t);
        }

        protected T read() {
            return this.data.poll();
        }

        private boolean hasDemand() {
            return DEMAND.get(this) > 0L;
        }

        private boolean changeState(State oldState, State newState) {
            return this.state.compareAndSet(oldState, newState);
        }

        void checkCommandDispatch() {
            this.commandDispatch.get().dispatch(this);
        }

        void dispatchCommand() {
            this.connection.dispatch(this.subscriptionCommand);
        }

        void checkOnDataAvailable() {
            if (this.data.isEmpty() && this.hasDemand()) {
                this.state().readData(this);
            }
            if (!this.data.isEmpty()) {
                this.onDataAvailable();
            }
        }

        private boolean readAndPublish() throws IOException {
            while (this.hasDemand()) {
                T data = this.read();
                if (data != null) {
                    this.subscriber.onNext(data);
                    if (Operators.addAndGet(DEMAND, (Object)this, (long)-1L) != 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        State state() {
            return this.state.get();
        }
    }
}

