/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
public class V1ThanosRulerSpecSecurityContext1WindowsOptions {
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC = "gmsaCredentialSpec";
    @SerializedName(value="gmsaCredentialSpec")
    private String gmsaCredentialSpec;
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME = "gmsaCredentialSpecName";
    @SerializedName(value="gmsaCredentialSpecName")
    private String gmsaCredentialSpecName;
    public static final String SERIALIZED_NAME_RUN_AS_USER_NAME = "runAsUserName";
    @SerializedName(value="runAsUserName")
    private String runAsUserName;

    public V1ThanosRulerSpecSecurityContext1WindowsOptions gmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.")
    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public V1ThanosRulerSpecSecurityContext1WindowsOptions gmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpecName is the name of the GMSA credential spec to use. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.")
    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public V1ThanosRulerSpecSecurityContext1WindowsOptions runAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. This field is beta-level and may be disabled with the WindowsRunAsUserName feature flag.")
    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecSecurityContext1WindowsOptions v1ThanosRulerSpecSecurityContext1WindowsOptions = (V1ThanosRulerSpecSecurityContext1WindowsOptions)o;
        return Objects.equals(this.gmsaCredentialSpec, v1ThanosRulerSpecSecurityContext1WindowsOptions.gmsaCredentialSpec) && Objects.equals(this.gmsaCredentialSpecName, v1ThanosRulerSpecSecurityContext1WindowsOptions.gmsaCredentialSpecName) && Objects.equals(this.runAsUserName, v1ThanosRulerSpecSecurityContext1WindowsOptions.runAsUserName);
    }

    public int hashCode() {
        return Objects.hash(this.gmsaCredentialSpec, this.gmsaCredentialSpecName, this.runAsUserName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecSecurityContext1WindowsOptions {\n");
        sb.append("    gmsaCredentialSpec: ").append(this.toIndentedString(this.gmsaCredentialSpec)).append("\n");
        sb.append("    gmsaCredentialSpecName: ").append(this.toIndentedString(this.gmsaCredentialSpecName)).append("\n");
        sb.append("    runAsUserName: ").append(this.toIndentedString(this.runAsUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

