/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
public class V1ThanosRulerSpecGcePersistentDisk {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_PARTITION = "partition";
    @SerializedName(value="partition")
    private Integer partition;
    public static final String SERIALIZED_NAME_PD_NAME = "pdName";
    @SerializedName(value="pdName")
    private String pdName;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;

    public V1ThanosRulerSpecGcePersistentDisk fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk TODO: how do we prevent errors in the filesystem from compromising the machine")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ThanosRulerSpecGcePersistentDisk partition(Integer partition) {
        this.partition = partition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public V1ThanosRulerSpecGcePersistentDisk pdName(String pdName) {
        this.pdName = pdName;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    public String getPdName() {
        return this.pdName;
    }

    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    public V1ThanosRulerSpecGcePersistentDisk readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecGcePersistentDisk v1ThanosRulerSpecGcePersistentDisk = (V1ThanosRulerSpecGcePersistentDisk)o;
        return Objects.equals(this.fsType, v1ThanosRulerSpecGcePersistentDisk.fsType) && Objects.equals(this.partition, v1ThanosRulerSpecGcePersistentDisk.partition) && Objects.equals(this.pdName, v1ThanosRulerSpecGcePersistentDisk.pdName) && Objects.equals(this.readOnly, v1ThanosRulerSpecGcePersistentDisk.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.partition, this.pdName, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecGcePersistentDisk {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    partition: ").append(this.toIndentedString(this.partition)).append("\n");
        sb.append("    pdName: ").append(this.toIndentedString(this.pdName)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

