/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.")
public class V1ThanosRulerSpecFc {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_LUN = "lun";
    @SerializedName(value="lun")
    private Integer lun;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_TARGET_W_W_NS = "targetWWNs";
    @SerializedName(value="targetWWNs")
    private List<String> targetWWNs = null;
    public static final String SERIALIZED_NAME_WWIDS = "wwids";
    @SerializedName(value="wwids")
    private List<String> wwids = null;

    public V1ThanosRulerSpecFc fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. TODO: how do we prevent errors in the filesystem from compromising the machine")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ThanosRulerSpecFc lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC target lun number")
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public V1ThanosRulerSpecFc readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ThanosRulerSpecFc targetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
        return this;
    }

    public V1ThanosRulerSpecFc addTargetWWNsItem(String targetWWNsItem) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(targetWWNsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC target worldwide names (WWNs)")
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    public void setTargetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
    }

    public V1ThanosRulerSpecFc wwids(List<String> wwids) {
        this.wwids = wwids;
        return this;
    }

    public V1ThanosRulerSpecFc addWwidsItem(String wwidsItem) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(wwidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.")
    public List<String> getWwids() {
        return this.wwids;
    }

    public void setWwids(List<String> wwids) {
        this.wwids = wwids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecFc v1ThanosRulerSpecFc = (V1ThanosRulerSpecFc)o;
        return Objects.equals(this.fsType, v1ThanosRulerSpecFc.fsType) && Objects.equals(this.lun, v1ThanosRulerSpecFc.lun) && Objects.equals(this.readOnly, v1ThanosRulerSpecFc.readOnly) && Objects.equals(this.targetWWNs, v1ThanosRulerSpecFc.targetWWNs) && Objects.equals(this.wwids, v1ThanosRulerSpecFc.wwids);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecFc {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    targetWWNs: ").append(this.toIndentedString(this.targetWWNs)).append("\n");
        sb.append("    wwids: ").append(this.toIndentedString(this.wwids)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

