/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.coreos.monitoring.models.V1ServiceMonitorSpecEndpoints;
import com.coreos.monitoring.models.V1ServiceMonitorSpecNamespaceSelector;
import com.coreos.monitoring.models.V1ServiceMonitorSpecSelector;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specification of desired Service selection for target discovery by Prometheus.")
public class V1ServiceMonitorSpec {
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    private List<V1ServiceMonitorSpecEndpoints> endpoints = new ArrayList<V1ServiceMonitorSpecEndpoints>();
    public static final String SERIALIZED_NAME_JOB_LABEL = "jobLabel";
    @SerializedName(value="jobLabel")
    private String jobLabel;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    private V1ServiceMonitorSpecNamespaceSelector namespaceSelector;
    public static final String SERIALIZED_NAME_POD_TARGET_LABELS = "podTargetLabels";
    @SerializedName(value="podTargetLabels")
    private List<String> podTargetLabels = null;
    public static final String SERIALIZED_NAME_SAMPLE_LIMIT = "sampleLimit";
    @SerializedName(value="sampleLimit")
    private Long sampleLimit;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1ServiceMonitorSpecSelector selector;
    public static final String SERIALIZED_NAME_TARGET_LABELS = "targetLabels";
    @SerializedName(value="targetLabels")
    private List<String> targetLabels = null;

    public V1ServiceMonitorSpec endpoints(List<V1ServiceMonitorSpecEndpoints> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public V1ServiceMonitorSpec addEndpointsItem(V1ServiceMonitorSpecEndpoints endpointsItem) {
        this.endpoints.add(endpointsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of endpoints allowed as part of this ServiceMonitor.")
    public List<V1ServiceMonitorSpecEndpoints> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<V1ServiceMonitorSpecEndpoints> endpoints) {
        this.endpoints = endpoints;
    }

    public V1ServiceMonitorSpec jobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The label to use to retrieve the job name from.")
    public String getJobLabel() {
        return this.jobLabel;
    }

    public void setJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
    }

    public V1ServiceMonitorSpec namespaceSelector(V1ServiceMonitorSpecNamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ServiceMonitorSpecNamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1ServiceMonitorSpecNamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1ServiceMonitorSpec podTargetLabels(List<String> podTargetLabels) {
        this.podTargetLabels = podTargetLabels;
        return this;
    }

    public V1ServiceMonitorSpec addPodTargetLabelsItem(String podTargetLabelsItem) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(podTargetLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PodTargetLabels transfers labels on the Kubernetes Pod onto the target.")
    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public void setPodTargetLabels(List<String> podTargetLabels) {
        this.podTargetLabels = podTargetLabels;
    }

    public V1ServiceMonitorSpec sampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SampleLimit defines per-scrape limit on number of scraped samples that will be accepted.")
    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
    }

    public V1ServiceMonitorSpec selector(V1ServiceMonitorSpecSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1ServiceMonitorSpecSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1ServiceMonitorSpecSelector selector) {
        this.selector = selector;
    }

    public V1ServiceMonitorSpec targetLabels(List<String> targetLabels) {
        this.targetLabels = targetLabels;
        return this;
    }

    public V1ServiceMonitorSpec addTargetLabelsItem(String targetLabelsItem) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.add(targetLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TargetLabels transfers labels on the Kubernetes Service onto the target.")
    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    public void setTargetLabels(List<String> targetLabels) {
        this.targetLabels = targetLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceMonitorSpec v1ServiceMonitorSpec = (V1ServiceMonitorSpec)o;
        return Objects.equals(this.endpoints, v1ServiceMonitorSpec.endpoints) && Objects.equals(this.jobLabel, v1ServiceMonitorSpec.jobLabel) && Objects.equals(this.namespaceSelector, v1ServiceMonitorSpec.namespaceSelector) && Objects.equals(this.podTargetLabels, v1ServiceMonitorSpec.podTargetLabels) && Objects.equals(this.sampleLimit, v1ServiceMonitorSpec.sampleLimit) && Objects.equals(this.selector, v1ServiceMonitorSpec.selector) && Objects.equals(this.targetLabels, v1ServiceMonitorSpec.targetLabels);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.jobLabel, this.namespaceSelector, this.podTargetLabels, this.sampleLimit, this.selector, this.targetLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceMonitorSpec {\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    jobLabel: ").append(this.toIndentedString(this.jobLabel)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    podTargetLabels: ").append(this.toIndentedString(this.podTargetLabels)).append("\n");
        sb.append("    sampleLimit: ").append(this.toIndentedString(this.sampleLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    targetLabels: ").append(this.toIndentedString(this.targetLabels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

