/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1beta1ChallengeSpecIssuerRef;
import io.cert.manager.models.V1beta1ChallengeSpecSolver;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1beta1ChallengeSpec {
    public static final String SERIALIZED_NAME_AUTHORIZATION_U_R_L = "authorizationURL";
    @SerializedName(value="authorizationURL")
    private String authorizationURL;
    public static final String SERIALIZED_NAME_DNS_NAME = "dnsName";
    @SerializedName(value="dnsName")
    private String dnsName;
    public static final String SERIALIZED_NAME_ISSUER_REF = "issuerRef";
    @SerializedName(value="issuerRef")
    private V1beta1ChallengeSpecIssuerRef issuerRef;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_SOLVER = "solver";
    @SerializedName(value="solver")
    private V1beta1ChallengeSpecSolver solver;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_WILDCARD = "wildcard";
    @SerializedName(value="wildcard")
    private Boolean wildcard;

    public V1beta1ChallengeSpec authorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to the ACME Authorization resource that this challenge is a part of.")
    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public void setAuthorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
    }

    public V1beta1ChallengeSpec dnsName(String dnsName) {
        this.dnsName = dnsName;
        return this;
    }

    @ApiModelProperty(required=true, value="dnsName is the identifier that this challenge is for, e.g. example.com. If the requested DNSName is a 'wildcard', this field MUST be set to the non-wildcard domain, e.g. for `*.example.com`, it must be `example.com`.")
    public String getDnsName() {
        return this.dnsName;
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    public V1beta1ChallengeSpec issuerRef(V1beta1ChallengeSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1beta1ChallengeSpecIssuerRef getIssuerRef() {
        return this.issuerRef;
    }

    public void setIssuerRef(V1beta1ChallengeSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
    }

    public V1beta1ChallengeSpec key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The ACME challenge key for this challenge For HTTP01 challenges, this is the value that must be responded with to complete the HTTP01 challenge in the format: `<private key JWK thumbprint>.<key from acme server for challenge>`. For DNS01 challenges, this is the base64 encoded SHA256 sum of the `<private key JWK thumbprint>.<key from acme server for challenge>` text that must be set as the TXT record content.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1beta1ChallengeSpec solver(V1beta1ChallengeSpecSolver solver) {
        this.solver = solver;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1beta1ChallengeSpecSolver getSolver() {
        return this.solver;
    }

    public void setSolver(V1beta1ChallengeSpecSolver solver) {
        this.solver = solver;
    }

    public V1beta1ChallengeSpec token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="The ACME challenge token for this challenge. This is the raw value returned from the ACME server.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public V1beta1ChallengeSpec type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of ACME challenge this resource represents. One of \"HTTP-01\" or \"DNS-01\".")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1beta1ChallengeSpec url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL of the ACME Challenge resource for this challenge. This can be used to lookup details about the status of this challenge.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public V1beta1ChallengeSpec wildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="wildcard will be true if this challenge is for a wildcard identifier, for example '*.example.com'.")
    public Boolean getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1ChallengeSpec v1beta1ChallengeSpec = (V1beta1ChallengeSpec)o;
        return Objects.equals(this.authorizationURL, v1beta1ChallengeSpec.authorizationURL) && Objects.equals(this.dnsName, v1beta1ChallengeSpec.dnsName) && Objects.equals(this.issuerRef, v1beta1ChallengeSpec.issuerRef) && Objects.equals(this.key, v1beta1ChallengeSpec.key) && Objects.equals(this.solver, v1beta1ChallengeSpec.solver) && Objects.equals(this.token, v1beta1ChallengeSpec.token) && Objects.equals((Object)this.type, (Object)v1beta1ChallengeSpec.type) && Objects.equals(this.url, v1beta1ChallengeSpec.url) && Objects.equals(this.wildcard, v1beta1ChallengeSpec.wildcard);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationURL, this.dnsName, this.issuerRef, this.key, this.solver, this.token, this.type, this.url, this.wildcard});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1ChallengeSpec {\n");
        sb.append("    authorizationURL: ").append(this.toIndentedString(this.authorizationURL)).append("\n");
        sb.append("    dnsName: ").append(this.toIndentedString(this.dnsName)).append("\n");
        sb.append("    issuerRef: ").append(this.toIndentedString(this.issuerRef)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    solver: ").append(this.toIndentedString(this.solver)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    wildcard: ").append(this.toIndentedString(this.wildcard)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        HTTP_01("HTTP-01"),
        DNS_01("DNS-01");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

