/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecVaultAuth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Vault configures this issuer to sign certificates using a HashiCorp Vault PKI backend.")
public class V1alpha2IssuerSpecVault {
    public static final String SERIALIZED_NAME_AUTH = "auth";
    @SerializedName(value="auth")
    private V1alpha2IssuerSpecVaultAuth auth;
    public static final String SERIALIZED_NAME_CA_BUNDLE = "caBundle";
    @SerializedName(value="caBundle")
    private byte[] caBundle;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_SERVER = "server";
    @SerializedName(value="server")
    private String server;

    public V1alpha2IssuerSpecVault auth(V1alpha2IssuerSpecVaultAuth auth) {
        this.auth = auth;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecVaultAuth getAuth() {
        return this.auth;
    }

    public void setAuth(V1alpha2IssuerSpecVaultAuth auth) {
        this.auth = auth;
    }

    public V1alpha2IssuerSpecVault caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PEM encoded CA bundle used to validate Vault server certificate. Only used if the Server URL is using HTTPS protocol. This parameter is ignored for plain HTTP protocol connection. If not set the system root certificates are used to validate the TLS connection.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1alpha2IssuerSpecVault path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path is the mount path of the Vault PKI backend's `sign` endpoint, e.g: \"my_pki_mount/sign/my-role-name\".")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1alpha2IssuerSpecVault server(String server) {
        this.server = server;
        return this;
    }

    @ApiModelProperty(required=true, value="Server is the connection address for the Vault server, e.g: \"https://vault.example.com:8200\".")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecVault v1alpha2IssuerSpecVault = (V1alpha2IssuerSpecVault)o;
        return Objects.equals(this.auth, v1alpha2IssuerSpecVault.auth) && Arrays.equals(this.caBundle, v1alpha2IssuerSpecVault.caBundle) && Objects.equals(this.path, v1alpha2IssuerSpecVault.path) && Objects.equals(this.server, v1alpha2IssuerSpecVault.server);
    }

    public int hashCode() {
        return Objects.hash(this.auth, Arrays.hashCode(this.caBundle), this.path, this.server);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecVault {\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

