/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeExternalAccountBindingKeySecretRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="ExternalAccountBinding is a reference to a CA external account of the ACME server. If set, upon registration cert-manager will attempt to associate the given external account credentials with the registered ACME account.")
public class V1alpha2IssuerSpecAcmeExternalAccountBinding {
    public static final String SERIALIZED_NAME_KEY_ALGORITHM = "keyAlgorithm";
    @SerializedName(value="keyAlgorithm")
    private KeyAlgorithmEnum keyAlgorithm;
    public static final String SERIALIZED_NAME_KEY_I_D = "keyID";
    @SerializedName(value="keyID")
    private String keyID;
    public static final String SERIALIZED_NAME_KEY_SECRET_REF = "keySecretRef";
    @SerializedName(value="keySecretRef")
    private V1alpha2IssuerSpecAcmeExternalAccountBindingKeySecretRef keySecretRef;

    public V1alpha2IssuerSpecAcmeExternalAccountBinding keyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    @ApiModelProperty(required=true, value="keyAlgorithm is the MAC key algorithm that the key is used for. Valid values are \"HS256\", \"HS384\" and \"HS512\".")
    public KeyAlgorithmEnum getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public V1alpha2IssuerSpecAcmeExternalAccountBinding keyID(String keyID) {
        this.keyID = keyID;
        return this;
    }

    @ApiModelProperty(required=true, value="keyID is the ID of the CA key that the External Account is bound to.")
    public String getKeyID() {
        return this.keyID;
    }

    public void setKeyID(String keyID) {
        this.keyID = keyID;
    }

    public V1alpha2IssuerSpecAcmeExternalAccountBinding keySecretRef(V1alpha2IssuerSpecAcmeExternalAccountBindingKeySecretRef keySecretRef) {
        this.keySecretRef = keySecretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecAcmeExternalAccountBindingKeySecretRef getKeySecretRef() {
        return this.keySecretRef;
    }

    public void setKeySecretRef(V1alpha2IssuerSpecAcmeExternalAccountBindingKeySecretRef keySecretRef) {
        this.keySecretRef = keySecretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeExternalAccountBinding v1alpha2IssuerSpecAcmeExternalAccountBinding = (V1alpha2IssuerSpecAcmeExternalAccountBinding)o;
        return Objects.equals((Object)this.keyAlgorithm, (Object)v1alpha2IssuerSpecAcmeExternalAccountBinding.keyAlgorithm) && Objects.equals(this.keyID, v1alpha2IssuerSpecAcmeExternalAccountBinding.keyID) && Objects.equals(this.keySecretRef, v1alpha2IssuerSpecAcmeExternalAccountBinding.keySecretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyAlgorithm, this.keyID, this.keySecretRef});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeExternalAccountBinding {\n");
        sb.append("    keyAlgorithm: ").append(this.toIndentedString((Object)this.keyAlgorithm)).append("\n");
        sb.append("    keyID: ").append(this.toIndentedString(this.keyID)).append("\n");
        sb.append("    keySecretRef: ").append(this.toIndentedString(this.keySecretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KeyAlgorithmEnum {
        HS256("HS256"),
        HS384("HS384"),
        HS512("HS512");

        private String value;

        private KeyAlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KeyAlgorithmEnum fromValue(String value) {
            for (KeyAlgorithmEnum b : KeyAlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KeyAlgorithmEnum> {
            public void write(JsonWriter jsonWriter, KeyAlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KeyAlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KeyAlgorithmEnum.fromValue(value);
            }
        }
    }
}

