package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DeploymentStrategyBuilder extends V1beta2DeploymentStrategyFluentImpl<V1beta2DeploymentStrategyBuilder> implements VisitableBuilder<V1beta2DeploymentStrategy,V1beta2DeploymentStrategyBuilder>{

    V1beta2DeploymentStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DeploymentStrategyBuilder(){
            this(true);
    }
    public V1beta2DeploymentStrategyBuilder(Boolean validationEnabled){
            this(new V1beta2DeploymentStrategy(), validationEnabled);
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DeploymentStrategy(), validationEnabled);
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategyFluent<?> fluent,V1beta2DeploymentStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategyFluent<?> fluent,V1beta2DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategy instance){
            this(instance,true);
    }
    public V1beta2DeploymentStrategyBuilder(V1beta2DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DeploymentStrategy build(){
            V1beta2DeploymentStrategy buildable = new V1beta2DeploymentStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DeploymentStrategyBuilder that = (V1beta2DeploymentStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
