package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ControllerRevisionBuilder extends V1beta2ControllerRevisionFluentImpl<V1beta2ControllerRevisionBuilder> implements VisitableBuilder<V1beta2ControllerRevision,V1beta2ControllerRevisionBuilder>{

    V1beta2ControllerRevisionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ControllerRevisionBuilder(){
            this(true);
    }
    public V1beta2ControllerRevisionBuilder(Boolean validationEnabled){
            this(new V1beta2ControllerRevision(), validationEnabled);
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevisionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevisionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ControllerRevision(), validationEnabled);
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevisionFluent<?> fluent,V1beta2ControllerRevision instance){
            this(fluent, instance, true);
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevisionFluent<?> fluent,V1beta2ControllerRevision instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withData(instance.getData());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevision instance){
            this(instance,true);
    }
    public V1beta2ControllerRevisionBuilder(V1beta2ControllerRevision instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ControllerRevision build(){
            V1beta2ControllerRevision buildable = new V1beta2ControllerRevision();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setData(fluent.getData());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setRevision(fluent.getRevision());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ControllerRevisionBuilder that = (V1beta2ControllerRevisionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
