package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1VolumeAttachmentSourceFluentImpl<A extends V1beta1VolumeAttachmentSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1VolumeAttachmentSourceFluent<A>{

    private V1PersistentVolumeSpecBuilder inlineVolumeSpec;
    private String persistentVolumeName;

    public V1beta1VolumeAttachmentSourceFluentImpl(){
    }
    public V1beta1VolumeAttachmentSourceFluentImpl(V1beta1VolumeAttachmentSource instance){
            this.withInlineVolumeSpec(instance.getInlineVolumeSpec());

            this.withPersistentVolumeName(instance.getPersistentVolumeName());

    }

    
/**
 * This method has been deprecated, please use method buildInlineVolumeSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1PersistentVolumeSpec getInlineVolumeSpec(){
            return this.inlineVolumeSpec!=null?this.inlineVolumeSpec.build():null;
    }

    public V1PersistentVolumeSpec buildInlineVolumeSpec(){
            return this.inlineVolumeSpec!=null?this.inlineVolumeSpec.build():null;
    }

    public A withInlineVolumeSpec(V1PersistentVolumeSpec inlineVolumeSpec){
            _visitables.get("inlineVolumeSpec").remove(this.inlineVolumeSpec);
            if (inlineVolumeSpec!=null){ this.inlineVolumeSpec= new V1PersistentVolumeSpecBuilder(inlineVolumeSpec); _visitables.get("inlineVolumeSpec").add(this.inlineVolumeSpec);} return (A) this;
    }

    public Boolean hasInlineVolumeSpec(){
            return this.inlineVolumeSpec != null;
    }

    public V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> withNewInlineVolumeSpec(){
            return new InlineVolumeSpecNestedImpl();
    }

    public V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> withNewInlineVolumeSpecLike(V1PersistentVolumeSpec item){
            return new InlineVolumeSpecNestedImpl(item);
    }

    public V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editInlineVolumeSpec(){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec());
    }

    public V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editOrNewInlineVolumeSpec(){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec() != null ? getInlineVolumeSpec(): new V1PersistentVolumeSpecBuilder().build());
    }

    public V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editOrNewInlineVolumeSpecLike(V1PersistentVolumeSpec item){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec() != null ? getInlineVolumeSpec(): item);
    }

    public String getPersistentVolumeName(){
            return this.persistentVolumeName;
    }

    public A withPersistentVolumeName(String persistentVolumeName){
            this.persistentVolumeName=persistentVolumeName; return (A) this;
    }

    public Boolean hasPersistentVolumeName(){
            return this.persistentVolumeName != null;
    }

    public A withNewPersistentVolumeName(String arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuilder arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuffer arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1VolumeAttachmentSourceFluentImpl that = (V1beta1VolumeAttachmentSourceFluentImpl) o;
            if (inlineVolumeSpec != null ? !inlineVolumeSpec.equals(that.inlineVolumeSpec) :that.inlineVolumeSpec != null) return false;
            if (persistentVolumeName != null ? !persistentVolumeName.equals(that.persistentVolumeName) :that.persistentVolumeName != null) return false;
            return true;
    }


    public class InlineVolumeSpecNestedImpl<N> extends V1PersistentVolumeSpecFluentImpl<V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<N>> implements V1beta1VolumeAttachmentSourceFluent.InlineVolumeSpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PersistentVolumeSpecBuilder builder;
    
            InlineVolumeSpecNestedImpl(V1PersistentVolumeSpec item){
                    this.builder = new V1PersistentVolumeSpecBuilder(this, item);
            }
            InlineVolumeSpecNestedImpl(){
                    this.builder = new V1PersistentVolumeSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1VolumeAttachmentSourceFluentImpl.this.withInlineVolumeSpec(builder.build());
    }
    public N endInlineVolumeSpec(){
            return and();
    }

}


}
