package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1beta1NetworkPolicyEgressRuleFluentImpl<A extends V1beta1NetworkPolicyEgressRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1NetworkPolicyEgressRuleFluent<A>{

    private List<V1beta1NetworkPolicyPortBuilder> ports;
    private List<V1beta1NetworkPolicyPeerBuilder> to;

    public V1beta1NetworkPolicyEgressRuleFluentImpl(){
    }
    public V1beta1NetworkPolicyEgressRuleFluentImpl(V1beta1NetworkPolicyEgressRule instance){
            this.withPorts(instance.getPorts());

            this.withTo(instance.getTo());

    }

    public A addToPorts(int index,V1beta1NetworkPolicyPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,V1beta1NetworkPolicyPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);
            if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(V1beta1NetworkPolicyPort... items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<V1beta1NetworkPolicyPort> items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>();}
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(V1beta1NetworkPolicyPort... items){
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<V1beta1NetworkPolicyPort> items){
            for (V1beta1NetworkPolicyPort item : items) {V1beta1NetworkPolicyPortBuilder builder = new V1beta1NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            if (ports == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyPortBuilder> each = ports.iterator();
            final List visitables = _visitables.get("ports");
            while (each.hasNext()) {
              V1beta1NetworkPolicyPortBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyPort> getPorts(){
            return build(ports);
    }

    public List<V1beta1NetworkPolicyPort> buildPorts(){
            return build(ports);
    }

    public V1beta1NetworkPolicyPort buildPort(int index){
            return this.ports.get(index).build();
    }

    public V1beta1NetworkPolicyPort buildFirstPort(){
            return this.ports.get(0).build();
    }

    public V1beta1NetworkPolicyPort buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public V1beta1NetworkPolicyPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            for (V1beta1NetworkPolicyPortBuilder item: ports) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            for (V1beta1NetworkPolicyPortBuilder item: ports) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPorts(List<V1beta1NetworkPolicyPort> ports){
            if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<V1beta1NetworkPolicyPortBuilder>(); for (V1beta1NetworkPolicyPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(V1beta1NetworkPolicyPort... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (V1beta1NetworkPolicyPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPortLike(V1beta1NetworkPolicyPort item){
            return new PortsNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> setNewPortLike(int index,V1beta1NetworkPolicyPort item){
            return new PortsNestedImpl(index, item);
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public A addToTo(int index,V1beta1NetworkPolicyPeer item){
            if (this.to == null) {this.to = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("to").add(index >= 0 ? index : _visitables.get("to").size(), builder);this.to.add(index >= 0 ? index : to.size(), builder); return (A)this;
    }

    public A setToTo(int index,V1beta1NetworkPolicyPeer item){
            if (this.to == null) {this.to = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);
            if (index < 0 || index >= _visitables.get("to").size()) { _visitables.get("to").add(builder); } else { _visitables.get("to").set(index, builder);}
            if (index < 0 || index >= to.size()) { to.add(builder); } else { to.set(index, builder);}
             return (A)this;
    }

    public A addToTo(V1beta1NetworkPolicyPeer... items){
            if (this.to == null) {this.to = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
    }

    public A addAllToTo(Collection<V1beta1NetworkPolicyPeer> items){
            if (this.to == null) {this.to = new ArrayList<V1beta1NetworkPolicyPeerBuilder>();}
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
    }

    public A removeFromTo(V1beta1NetworkPolicyPeer... items){
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
    }

    public A removeAllFromTo(Collection<V1beta1NetworkPolicyPeer> items){
            for (V1beta1NetworkPolicyPeer item : items) {V1beta1NetworkPolicyPeerBuilder builder = new V1beta1NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTo(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            if (to == null) return (A) this;
            final Iterator<V1beta1NetworkPolicyPeerBuilder> each = to.iterator();
            final List visitables = _visitables.get("to");
            while (each.hasNext()) {
              V1beta1NetworkPolicyPeerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTo instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicyPeer> getTo(){
            return build(to);
    }

    public List<V1beta1NetworkPolicyPeer> buildTo(){
            return build(to);
    }

    public V1beta1NetworkPolicyPeer buildTo(int index){
            return this.to.get(index).build();
    }

    public V1beta1NetworkPolicyPeer buildFirstTo(){
            return this.to.get(0).build();
    }

    public V1beta1NetworkPolicyPeer buildLastTo(){
            return this.to.get(to.size() - 1).build();
    }

    public V1beta1NetworkPolicyPeer buildMatchingTo(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            for (V1beta1NetworkPolicyPeerBuilder item: to) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTo(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            for (V1beta1NetworkPolicyPeerBuilder item: to) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTo(List<V1beta1NetworkPolicyPeer> to){
            if (this.to != null) { _visitables.get("to").removeAll(this.to);}
            if (to != null) {this.to = new ArrayList<V1beta1NetworkPolicyPeerBuilder>(); for (V1beta1NetworkPolicyPeer item : to){this.addToTo(item);}} else { this.to = null;} return (A) this;
    }

    public A withTo(V1beta1NetworkPolicyPeer... to){
            if (this.to != null) {this.to.clear();}
            if (to != null) {for (V1beta1NetworkPolicyPeer item :to){ this.addToTo(item);}} return (A) this;
    }

    public Boolean hasTo(){
            return to != null && !to.isEmpty();
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> addNewTo(){
            return new ToNestedImpl();
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> addNewToLike(V1beta1NetworkPolicyPeer item){
            return new ToNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> setNewToLike(int index,V1beta1NetworkPolicyPeer item){
            return new ToNestedImpl(index, item);
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> editTo(int index){
            if (to.size() <= index) throw new RuntimeException("Can't edit to. Index exceeds size.");
            return setNewToLike(index, buildTo(index));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> editFirstTo(){
            if (to.size() == 0) throw new RuntimeException("Can't edit first to. The list is empty.");
            return setNewToLike(0, buildTo(0));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> editLastTo(){
            int index = to.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last to. The list is empty.");
            return setNewToLike(index, buildTo(index));
    }

    public V1beta1NetworkPolicyEgressRuleFluent.ToNested<A> editMatchingTo(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyPeerBuilder> predicate){
            int index = -1;
            for (int i=0;i<to.size();i++) { 
            if (predicate.apply(to.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching to. No match found.");
            return setNewToLike(index, buildTo(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1NetworkPolicyEgressRuleFluentImpl that = (V1beta1NetworkPolicyEgressRuleFluentImpl) o;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (to != null ? !to.equals(that.to) :that.to != null) return false;
            return true;
    }


    public class PortsNestedImpl<N> extends V1beta1NetworkPolicyPortFluentImpl<V1beta1NetworkPolicyEgressRuleFluent.PortsNested<N>> implements V1beta1NetworkPolicyEgressRuleFluent.PortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyPortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,V1beta1NetworkPolicyPort item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyPortBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyEgressRuleFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class ToNestedImpl<N> extends V1beta1NetworkPolicyPeerFluentImpl<V1beta1NetworkPolicyEgressRuleFluent.ToNested<N>> implements V1beta1NetworkPolicyEgressRuleFluent.ToNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyPeerBuilder builder;
        private final int index;
    
            ToNestedImpl(int index,V1beta1NetworkPolicyPeer item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyPeerBuilder(this, item);
            }
            ToNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyPeerBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyEgressRuleFluentImpl.this.setToTo(index,builder.build());
    }
    public N endTo(){
            return and();
    }

}


}
