package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1DaemonSetConditionBuilder extends V1beta1DaemonSetConditionFluentImpl<V1beta1DaemonSetConditionBuilder> implements VisitableBuilder<V1beta1DaemonSetCondition,V1beta1DaemonSetConditionBuilder>{

    V1beta1DaemonSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1DaemonSetConditionBuilder(){
            this(true);
    }
    public V1beta1DaemonSetConditionBuilder(Boolean validationEnabled){
            this(new V1beta1DaemonSetCondition(), validationEnabled);
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1DaemonSetCondition(), validationEnabled);
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetConditionFluent<?> fluent,V1beta1DaemonSetCondition instance){
            this(fluent, instance, true);
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetConditionFluent<?> fluent,V1beta1DaemonSetCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetCondition instance){
            this(instance,true);
    }
    public V1beta1DaemonSetConditionBuilder(V1beta1DaemonSetCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1DaemonSetCondition build(){
            V1beta1DaemonSetCondition buildable = new V1beta1DaemonSetCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1DaemonSetConditionBuilder that = (V1beta1DaemonSetConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
