package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface V1ObjectMetaFluent<A extends V1ObjectMetaFluent<A>> extends Fluent<A>{


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public String getClusterName();
    public A withClusterName(String clusterName);
    public Boolean hasClusterName();
    public A withNewClusterName(String arg1);
    public A withNewClusterName(StringBuilder arg1);
    public A withNewClusterName(StringBuffer arg1);
    public DateTime getCreationTimestamp();
    public A withCreationTimestamp(DateTime creationTimestamp);
    public Boolean hasCreationTimestamp();
    public A withNewCreationTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewCreationTimestamp(Object arg0);
    public A withNewCreationTimestamp(long arg0);
    public Long getDeletionGracePeriodSeconds();
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds);
    public Boolean hasDeletionGracePeriodSeconds();
    public DateTime getDeletionTimestamp();
    public A withDeletionTimestamp(DateTime deletionTimestamp);
    public Boolean hasDeletionTimestamp();
    public A withNewDeletionTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewDeletionTimestamp(Object arg0);
    public A withNewDeletionTimestamp(long arg0);
    public A addToFinalizers(int index,String item);
    public A setToFinalizers(int index,String item);
    public A addToFinalizers(String... items);
    public A addAllToFinalizers(Collection<String> items);
    public A removeFromFinalizers(String... items);
    public A removeAllFromFinalizers(Collection<String> items);
    public List<String> getFinalizers();
    public String getFinalizer(int index);
    public String getFirstFinalizer();
    public String getLastFinalizer();
    public String getMatchingFinalizer(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingFinalizer(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withFinalizers(List<String> finalizers);
    public A withFinalizers(String... finalizers);
    public Boolean hasFinalizers();
    public A addNewFinalizer(String arg1);
    public A addNewFinalizer(StringBuilder arg1);
    public A addNewFinalizer(StringBuffer arg1);
    public String getGenerateName();
    public A withGenerateName(String generateName);
    public Boolean hasGenerateName();
    public A withNewGenerateName(String arg1);
    public A withNewGenerateName(StringBuilder arg1);
    public A withNewGenerateName(StringBuffer arg1);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToManagedFields(int index,V1ManagedFieldsEntry item);
    public A setToManagedFields(int index,V1ManagedFieldsEntry item);
    public A addToManagedFields(V1ManagedFieldsEntry... items);
    public A addAllToManagedFields(Collection<V1ManagedFieldsEntry> items);
    public A removeFromManagedFields(V1ManagedFieldsEntry... items);
    public A removeAllFromManagedFields(Collection<V1ManagedFieldsEntry> items);
    public A removeMatchingFromManagedFields(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildManagedFields instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ManagedFieldsEntry> getManagedFields();
    public List<V1ManagedFieldsEntry> buildManagedFields();
    public V1ManagedFieldsEntry buildManagedField(int index);
    public V1ManagedFieldsEntry buildFirstManagedField();
    public V1ManagedFieldsEntry buildLastManagedField();
    public V1ManagedFieldsEntry buildMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate);
    public Boolean hasMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate);
    public A withManagedFields(List<V1ManagedFieldsEntry> managedFields);
    public A withManagedFields(V1ManagedFieldsEntry... managedFields);
    public Boolean hasManagedFields();
    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField();
    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(V1ManagedFieldsEntry item);
    public V1ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(int index,V1ManagedFieldsEntry item);
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(int index);
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField();
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField();
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(io.kubernetes.client.fluent.Predicate<V1ManagedFieldsEntryBuilder> predicate);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public A addToOwnerReferences(int index,V1OwnerReference item);
    public A setToOwnerReferences(int index,V1OwnerReference item);
    public A addToOwnerReferences(V1OwnerReference... items);
    public A addAllToOwnerReferences(Collection<V1OwnerReference> items);
    public A removeFromOwnerReferences(V1OwnerReference... items);
    public A removeAllFromOwnerReferences(Collection<V1OwnerReference> items);
    public A removeMatchingFromOwnerReferences(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildOwnerReferences instead.
 * @return The buildable object.
 */
@Deprecated public List<V1OwnerReference> getOwnerReferences();
    public List<V1OwnerReference> buildOwnerReferences();
    public V1OwnerReference buildOwnerReference(int index);
    public V1OwnerReference buildFirstOwnerReference();
    public V1OwnerReference buildLastOwnerReference();
    public V1OwnerReference buildMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate);
    public Boolean hasMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate);
    public A withOwnerReferences(List<V1OwnerReference> ownerReferences);
    public A withOwnerReferences(V1OwnerReference... ownerReferences);
    public Boolean hasOwnerReferences();
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference();
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(V1OwnerReference item);
    public V1ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(int index,V1OwnerReference item);
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(int index);
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference();
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference();
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(io.kubernetes.client.fluent.Predicate<V1OwnerReferenceBuilder> predicate);
    public String getResourceVersion();
    public A withResourceVersion(String resourceVersion);
    public Boolean hasResourceVersion();
    public A withNewResourceVersion(String arg1);
    public A withNewResourceVersion(StringBuilder arg1);
    public A withNewResourceVersion(StringBuffer arg1);
    public String getSelfLink();
    public A withSelfLink(String selfLink);
    public Boolean hasSelfLink();
    public A withNewSelfLink(String arg1);
    public A withNewSelfLink(StringBuilder arg1);
    public A withNewSelfLink(StringBuffer arg1);
    public String getUid();
    public A withUid(String uid);
    public Boolean hasUid();
    public A withNewUid(String arg1);
    public A withNewUid(StringBuilder arg1);
    public A withNewUid(StringBuffer arg1);

    public interface ManagedFieldsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ManagedFieldsEntryFluent<V1ObjectMetaFluent.ManagedFieldsNested<N>>{

        
    public N and();    public N endManagedField();
}
    public interface OwnerReferencesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1OwnerReferenceFluent<V1ObjectMetaFluent.OwnerReferencesNested<N>>{

        
    public N and();    public N endOwnerReference();
}


}
