package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1LoadBalancerStatusFluent<A extends V1LoadBalancerStatusFluent<A>> extends Fluent<A>{


    public A addToIngress(int index,V1LoadBalancerIngress item);
    public A setToIngress(int index,V1LoadBalancerIngress item);
    public A addToIngress(V1LoadBalancerIngress... items);
    public A addAllToIngress(Collection<V1LoadBalancerIngress> items);
    public A removeFromIngress(V1LoadBalancerIngress... items);
    public A removeAllFromIngress(Collection<V1LoadBalancerIngress> items);
    public A removeMatchingFromIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LoadBalancerIngress> getIngress();
    public List<V1LoadBalancerIngress> buildIngress();
    public V1LoadBalancerIngress buildIngress(int index);
    public V1LoadBalancerIngress buildFirstIngress();
    public V1LoadBalancerIngress buildLastIngress();
    public V1LoadBalancerIngress buildMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate);
    public Boolean hasMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate);
    public A withIngress(List<V1LoadBalancerIngress> ingress);
    public A withIngress(V1LoadBalancerIngress... ingress);
    public Boolean hasIngress();
    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngress();
    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(V1LoadBalancerIngress item);
    public V1LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(int index,V1LoadBalancerIngress item);
    public V1LoadBalancerStatusFluent.IngressNested<A> editIngress(int index);
    public V1LoadBalancerStatusFluent.IngressNested<A> editFirstIngress();
    public V1LoadBalancerStatusFluent.IngressNested<A> editLastIngress();
    public V1LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(io.kubernetes.client.fluent.Predicate<V1LoadBalancerIngressBuilder> predicate);

    public interface IngressNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LoadBalancerIngressFluent<V1LoadBalancerStatusFluent.IngressNested<N>>{

        
    public N and();    public N endIngress();
}


}
