package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1AllowedCSIDriverBuilder extends PolicyV1beta1AllowedCSIDriverFluentImpl<PolicyV1beta1AllowedCSIDriverBuilder> implements VisitableBuilder<PolicyV1beta1AllowedCSIDriver,PolicyV1beta1AllowedCSIDriverBuilder>{

    PolicyV1beta1AllowedCSIDriverFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1AllowedCSIDriverBuilder(){
            this(true);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1AllowedCSIDriver(), validationEnabled);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriverFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1AllowedCSIDriver(), validationEnabled);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriverFluent<?> fluent,PolicyV1beta1AllowedCSIDriver instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriverFluent<?> fluent,PolicyV1beta1AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriver instance){
            this(instance,true);
    }
    public PolicyV1beta1AllowedCSIDriverBuilder(PolicyV1beta1AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1AllowedCSIDriver build(){
            PolicyV1beta1AllowedCSIDriver buildable = new PolicyV1beta1AllowedCSIDriver();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1AllowedCSIDriverBuilder that = (PolicyV1beta1AllowedCSIDriverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
