/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.")
public class V1RBDVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    @Nullable
    private String fsType;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    @Nonnull
    private String image;
    public static final String SERIALIZED_NAME_KEYRING = "keyring";
    @SerializedName(value="keyring")
    @Nullable
    private String keyring;
    public static final String SERIALIZED_NAME_MONITORS = "monitors";
    @SerializedName(value="monitors")
    @Nonnull
    private List<String> monitors = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nullable
    private String pool;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    @Nullable
    private V1LocalObjectReference secretRef;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    @Nullable
    private String user;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1RBDVolumeSource fsType(@Nullable String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(@Nullable String fsType) {
        this.fsType = fsType;
    }

    public V1RBDVolumeSource image(@Nonnull String image) {
        this.image = image;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getImage() {
        return this.image;
    }

    public void setImage(@Nonnull String image) {
        this.image = image;
    }

    public V1RBDVolumeSource keyring(@Nullable String keyring) {
        this.keyring = keyring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(@Nullable String keyring) {
        this.keyring = keyring;
    }

    public V1RBDVolumeSource monitors(@Nonnull List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public V1RBDVolumeSource addMonitorsItem(String monitorsItem) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(monitorsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(@Nonnull List<String> monitors) {
        this.monitors = monitors;
    }

    public V1RBDVolumeSource pool(@Nullable String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getPool() {
        return this.pool;
    }

    public void setPool(@Nullable String pool) {
        this.pool = pool;
    }

    public V1RBDVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1RBDVolumeSource secretRef(@Nullable V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(@Nullable V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1RBDVolumeSource user(@Nullable String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RBDVolumeSource v1RBDVolumeSource = (V1RBDVolumeSource)o;
        return Objects.equals(this.fsType, v1RBDVolumeSource.fsType) && Objects.equals(this.image, v1RBDVolumeSource.image) && Objects.equals(this.keyring, v1RBDVolumeSource.keyring) && Objects.equals(this.monitors, v1RBDVolumeSource.monitors) && Objects.equals(this.pool, v1RBDVolumeSource.pool) && Objects.equals(this.readOnly, v1RBDVolumeSource.readOnly) && Objects.equals(this.secretRef, v1RBDVolumeSource.secretRef) && Objects.equals(this.user, v1RBDVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1RBDVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    keyring: ").append(this.toIndentedString(this.keyring)).append("\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1RBDVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1RBDVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEYRING) != null && !jsonObj.get(SERIALIZED_NAME_KEYRING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KEYRING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `keyring` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEYRING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MONITORS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_MONITORS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `monitors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MONITORS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POOL) != null && !jsonObj.get(SERIALIZED_NAME_POOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_SECRET_REF).isJsonNull()) {
            V1LocalObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECRET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
    }

    public static V1RBDVolumeSource fromJson(String jsonString) throws IOException {
        return (V1RBDVolumeSource)JSON.getGson().fromJson(jsonString, V1RBDVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_KEYRING);
        openapiFields.add(SERIALIZED_NAME_MONITORS);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IMAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_MONITORS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1RBDVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1RBDVolumeSource.class));
            return new TypeAdapter<V1RBDVolumeSource>(){

                public void write(JsonWriter out, V1RBDVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1RBDVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1RBDVolumeSource.validateJsonElement(jsonElement);
                    return (V1RBDVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

