/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1TypedLocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="IngressBackend describes all endpoints for a given service and port.")
public class V1IngressBackend {
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    @Nullable
    private V1TypedLocalObjectReference resource;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    @Nullable
    private V1IngressServiceBackend service;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IngressBackend resource(@Nullable V1TypedLocalObjectReference resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public void setResource(@Nullable V1TypedLocalObjectReference resource) {
        this.resource = resource;
    }

    public V1IngressBackend service(@Nullable V1IngressServiceBackend service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1IngressServiceBackend getService() {
        return this.service;
    }

    public void setService(@Nullable V1IngressServiceBackend service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressBackend v1IngressBackend = (V1IngressBackend)o;
        return Objects.equals(this.resource, v1IngressBackend.resource) && Objects.equals(this.service, v1IngressBackend.service);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressBackend {\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IngressBackend is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IngressBackend` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE).isJsonNull()) {
            V1TypedLocalObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE).isJsonNull()) {
            V1IngressServiceBackend.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERVICE));
        }
    }

    public static V1IngressBackend fromJson(String jsonString) throws IOException {
        return (V1IngressBackend)JSON.getGson().fromJson(jsonString, V1IngressBackend.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESOURCE);
        openapiFields.add(SERIALIZED_NAME_SERVICE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IngressBackend.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IngressBackend.class));
            return new TypeAdapter<V1IngressBackend>(){

                public void write(JsonWriter out, V1IngressBackend value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IngressBackend read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1IngressBackend.validateJsonElement(jsonElement);
                    return (V1IngressBackend)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

