/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1NetworkPolicySpec {
    public static final String SERIALIZED_NAME_EGRESS = "egress";
    @SerializedName(value="egress")
    private List<V1NetworkPolicyEgressRule> egress;
    public static final String SERIALIZED_NAME_INGRESS = "ingress";
    @SerializedName(value="ingress")
    private List<V1NetworkPolicyIngressRule> ingress;
    public static final String SERIALIZED_NAME_POD_SELECTOR = "podSelector";
    @SerializedName(value="podSelector")
    private V1LabelSelector podSelector;
    public static final String SERIALIZED_NAME_POLICY_TYPES = "policyTypes";
    @SerializedName(value="policyTypes")
    private List<String> policyTypes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NetworkPolicySpec egress(List<V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
        return this;
    }

    public V1NetworkPolicySpec addEgressItem(V1NetworkPolicyEgressRule egressItem) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1NetworkPolicyEgressRule>();
        }
        this.egress.add(egressItem);
        return this;
    }

    @Nullable
    public List<V1NetworkPolicyEgressRule> getEgress() {
        return this.egress;
    }

    public void setEgress(List<V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
    }

    public V1NetworkPolicySpec ingress(List<V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1NetworkPolicySpec addIngressItem(V1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @Nullable
    public List<V1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public V1NetworkPolicySpec podSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @Nonnull
    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public V1NetworkPolicySpec policyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    public V1NetworkPolicySpec addPolicyTypesItem(String policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    @Nullable
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicySpec v1NetworkPolicySpec = (V1NetworkPolicySpec)o;
        return Objects.equals(this.egress, v1NetworkPolicySpec.egress) && Objects.equals(this.ingress, v1NetworkPolicySpec.ingress) && Objects.equals(this.podSelector, v1NetworkPolicySpec.podSelector) && Objects.equals(this.policyTypes, v1NetworkPolicySpec.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicySpec {\n");
        sb.append("    egress: ").append(this.toIndentedString(this.egress)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("    policyTypes: ").append(this.toIndentedString(this.policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayingress;
        JsonArray jsonArrayegress;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NetworkPolicySpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NetworkPolicySpec` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EGRESS) != null && !jsonObj.get(SERIALIZED_NAME_EGRESS).isJsonNull() && (jsonArrayegress = jsonObj.getAsJsonArray(SERIALIZED_NAME_EGRESS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EGRESS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `egress` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EGRESS).toString()));
            }
            for (int i = 0; i < jsonArrayegress.size(); ++i) {
                V1NetworkPolicyEgressRule.validateJsonObject(jsonArrayegress.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INGRESS) != null && !jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonNull() && (jsonArrayingress = jsonObj.getAsJsonArray(SERIALIZED_NAME_INGRESS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ingress` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INGRESS).toString()));
            }
            for (int i = 0; i < jsonArrayingress.size(); ++i) {
                V1NetworkPolicyIngressRule.validateJsonObject(jsonArrayingress.get(i).getAsJsonObject());
            }
        }
        V1LabelSelector.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_POD_SELECTOR));
        if (jsonObj.get(SERIALIZED_NAME_POLICY_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_POLICY_TYPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `policyTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POLICY_TYPES).toString()));
        }
    }

    public static V1NetworkPolicySpec fromJson(String jsonString) throws IOException {
        return (V1NetworkPolicySpec)JSON.getGson().fromJson(jsonString, V1NetworkPolicySpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EGRESS);
        openapiFields.add(SERIALIZED_NAME_INGRESS);
        openapiFields.add(SERIALIZED_NAME_POD_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_POLICY_TYPES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_POD_SELECTOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NetworkPolicySpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NetworkPolicySpec.class));
            return new TypeAdapter<V1NetworkPolicySpec>(){

                public void write(JsonWriter out, V1NetworkPolicySpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NetworkPolicySpec read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1NetworkPolicySpec.validateJsonObject(jsonObj);
                    return (V1NetworkPolicySpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

