/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NonResourceRule holds information that describes a rule for the non-resource")
public class V1NonResourceRule {
    @SerializedName(value="nonResourceURLs")
    private List<String> nonResourceURLs = null;
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();

    public V1NonResourceRule nonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public V1NonResourceRule addNonResourceURLsItem(String nonResourceURLsItem) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    @ApiModelProperty(value="NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  \"*\" means all.")
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public V1NonResourceRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1NonResourceRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  \"*\" means all.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NonResourceRule v1NonResourceRule = (V1NonResourceRule)o;
        return Objects.equals(this.nonResourceURLs, v1NonResourceRule.nonResourceURLs) && Objects.equals(this.verbs, v1NonResourceRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NonResourceRule {\n");
        sb.append("    nonResourceURLs: ").append(this.toIndentedString(this.nonResourceURLs)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

