/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.teamcity;

import io.kotest.common.reflection.ReflectionKt;
import io.kotest.core.source.SourceRef;
import io.kotest.core.spec.SpecRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lio/kotest/engine/teamcity/Locations;", "", "<init>", "()V", "location", "", "ref", "Lio/kotest/core/source/SourceRef;", "Lio/kotest/core/spec/SpecRef;", "classHint", "fqn", "lineNumber", "", "kotest-framework-engine"})
public final class Locations {
    @NotNull
    public static final Locations INSTANCE = new Locations();

    private Locations() {
    }

    @Nullable
    public final String location(@NotNull SourceRef ref) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        SourceRef sourceRef = ref;
        if (sourceRef instanceof SourceRef.ClassSource) {
            string = this.classHint(((SourceRef.ClassSource)ref).getFqn(), 1);
        } else if (sourceRef instanceof SourceRef.ClassLineSource) {
            Integer n = ((SourceRef.ClassLineSource)ref).getLineNumber();
            string = this.classHint(((SourceRef.ClassLineSource)ref).getFqn(), n != null ? n : 1);
        } else if (Intrinsics.areEqual((Object)sourceRef, (Object)SourceRef.None.INSTANCE)) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public final String location(@NotNull SpecRef ref) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        SpecRef specRef = ref;
        if (specRef instanceof SpecRef.Function) {
            string = this.classHint(((SpecRef.Function)ref).getFqn(), 1);
        } else if (specRef instanceof SpecRef.Reference) {
            string = this.classHint(ReflectionKt.bestName(((SpecRef.Reference)ref).getKclass()), 1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String classHint(String fqn, int lineNumber) {
        return "kotest://" + fqn + ":" + lineNumber;
    }
}

