/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.collections;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.collections.DuplicatesKt;
import io.kotest.matchers.collections.DuplicationByEqualsReport;
import io.kotest.matchers.collections.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotest/matchers/collections/ContainDuplicatesMatcher;", "T", "Lio/kotest/matchers/Matcher;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "test", "Lio/kotest/matchers/MatcherResult;", "value", "kotest-assertions-core"})
public final class ContainDuplicatesMatcher<T>
implements Matcher<Iterable<? extends T>> {
    @Nullable
    private final String name;

    public ContainDuplicatesMatcher(@Nullable String name) {
        this.name = name;
    }

    @NotNull
    public MatcherResult test(@NotNull Iterable<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String string = this.name;
        if (string == null) {
            string = UtilsKt.containerName(value);
        }
        String name = string;
        DuplicationByEqualsReport<T> report = DuplicatesKt.duplicationByEqualsReport(value);
        return MatcherResult.Companion.invoke(report.hasDuplicates(), () -> ContainDuplicatesMatcher.test$lambda$0(name), () -> ContainDuplicatesMatcher.test$lambda$1(name, report));
    }

    private static final String test$lambda$0(String $name) {
        return $name + " should contain duplicates";
    }

    private static final String test$lambda$1(String $name, DuplicationByEqualsReport $report) {
        return $name + " should not contain duplicates, but has:\n" + $report.standardMessage();
    }
}

