/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.EmptyKt;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a8\u0006\u0006"}, d2={"shouldBeEmptyDirectory", "", "Ljava/nio/file/Path;", "shouldNotBeEmptyDirectory", "beEmptyDirectory", "Lio/kotest/matchers/Matcher;", "kotest-assertions-core"})
public final class EmptyKt {
    public static final void shouldBeEmptyDirectory(@NotNull Path $this$shouldBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmptyDirectory, (String)"<this>");
        ShouldKt.should($this$shouldBeEmptyDirectory, EmptyKt.beEmptyDirectory());
    }

    public static final void shouldNotBeEmptyDirectory(@NotNull Path $this$shouldNotBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeEmptyDirectory, EmptyKt.beEmptyDirectory());
    }

    @NotNull
    public static final Matcher<Path> beEmptyDirectory() {
        return (Matcher)new Matcher<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MatcherResult test(Path value) {
                MatcherResult matcherResult;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(value, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    int n;
                    Closeable closeable = Files.newDirectoryStream(value);
                    Throwable throwable = null;
                    try {
                        DirectoryStream it = (DirectoryStream)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        n = CollectionsKt.count((Iterable)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    int count = n;
                    matcherResult = MatcherResult.Companion.invoke(count == 0, () -> beEmptyDirectory.1.test$lambda$1(value, count), () -> beEmptyDirectory.1.test$lambda$2(value));
                } else {
                    String string;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (Files.isRegularFile(value, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                        string = "was a regular file";
                    } else {
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        string = !Files.exists(value, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? "it does not exist" : "could not determine type";
                    }
                    String reason = string;
                    matcherResult = MatcherResult.Companion.invoke(false, () -> beEmptyDirectory.1.test$lambda$3(value, reason), () -> beEmptyDirectory.1.test$lambda$4(value, reason));
                }
                return matcherResult;
            }

            private static final String test$lambda$1(Path $value, int $count) {
                return $value + " should be an empty directory but contained " + $count + " file(s)";
            }

            private static final String test$lambda$2(Path $value) {
                return $value + " should not be a non-empty directory";
            }

            private static final String test$lambda$3(Path $value, String $reason) {
                return $value + " should be an empty directory, but " + $reason;
            }

            private static final String test$lambda$4(Path $value, String $reason) {
                return $value + " should not be a non-empty directory, but " + $reason;
            }
        };
    }
}

