/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.floats;

import io.kotest.assertions.AssertionsConfig;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.floats.MatchersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u001b\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0015\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\u0019\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001a\u0010\u001f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u00a8\u0006!"}, d2={"exactly", "Lio/kotest/matchers/Matcher;", "", "d", "exactlyByBits", "expected", "lt", "x", "beLessThan", "lte", "beLessThanOrEqualTo", "gt", "beGreaterThan", "gte", "beGreaterThanOrEqualTo", "shouldBeLessThan", "shouldNotBeLessThan", "shouldBeLessThanOrEqual", "shouldNotBeLessThanOrEqual", "shouldBeGreaterThan", "shouldNotBeGreaterThan", "shouldBeGreaterThanOrEqual", "shouldNotBeGreaterThanOrEqual", "shouldBeExactly", "shouldNotBeExactly", "shouldBeZero", "shouldNotBeZero", "shouldBeWithinPercentageOf", "other", "percentage", "", "shouldNotBeWithinPercentageOf", "beWithinPercentageOf", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/floats/MatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class MatchersKt {
    @NotNull
    public static final Matcher<Float> exactly(float d) {
        return (Matcher)new Matcher<Float>(d){
            final /* synthetic */ float $d;
            {
                this.$d = $d;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value == this.$d, () -> exactly.1.test$lambda$0(value, this.$d), () -> exactly.1.test$lambda$1(value, this.$d));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $d) {
                return $value + " is not equal to expected value " + $d;
            }

            private static final String test$lambda$1(float $value, float $d) {
                return $value + " should not be equal to " + $d;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> exactlyByBits(float expected) {
        return (Matcher)new Matcher<Float>(expected){
            final /* synthetic */ float $expected;
            {
                this.$expected = $expected;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(Float.floatToIntBits(value) == Float.floatToIntBits(this.$expected), () -> exactlyByBits.1.test$lambda$0(value, this.$expected), () -> exactlyByBits.1.test$lambda$1(value, this.$expected));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $expected) {
                return $value + " is not equal to expected value " + $expected;
            }

            private static final String test$lambda$1(float $value, float $expected) {
                return $value + " should not equal " + $expected;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> lt(float x) {
        return MatchersKt.beLessThan(x);
    }

    @NotNull
    public static final Matcher<Float> beLessThan(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value < this.$x, () -> beLessThan.1.test$lambda$0(value, this.$x), () -> beLessThan.1.test$lambda$1(value, this.$x));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be < " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be < " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> lte(float x) {
        return MatchersKt.beLessThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Float> beLessThanOrEqualTo(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value <= this.$x, () -> beLessThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beLessThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be <= " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be <= " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> gt(float x) {
        return MatchersKt.beGreaterThan(x);
    }

    @NotNull
    public static final Matcher<Float> beGreaterThan(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value > this.$x, () -> beGreaterThan.1.test$lambda$0(value, this.$x), () -> beGreaterThan.1.test$lambda$1(value, this.$x));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be > " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be > " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> gte(float x) {
        return MatchersKt.beGreaterThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Float> beGreaterThanOrEqualTo(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value >= this.$x, () -> beGreaterThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beGreaterThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be >= " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be >= " + $x;
            }
        };
    }

    public static final float shouldBeLessThan(float $this$shouldBeLessThan, float x) {
        ShouldKt.shouldBe(Float.valueOf($this$shouldBeLessThan), MatchersKt.lt(x));
        return $this$shouldBeLessThan;
    }

    public static final float shouldNotBeLessThan(float $this$shouldNotBeLessThan, float x) {
        ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeLessThan), MatchersKt.lt(x));
        return $this$shouldNotBeLessThan;
    }

    public static final float shouldBeLessThanOrEqual(float $this$shouldBeLessThanOrEqual, float x) {
        ShouldKt.shouldBe(Float.valueOf($this$shouldBeLessThanOrEqual), MatchersKt.lte(x));
        return $this$shouldBeLessThanOrEqual;
    }

    public static final float shouldNotBeLessThanOrEqual(float $this$shouldNotBeLessThanOrEqual, float x) {
        ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeLessThanOrEqual), MatchersKt.lte(x));
        return $this$shouldNotBeLessThanOrEqual;
    }

    public static final float shouldBeGreaterThan(float $this$shouldBeGreaterThan, float x) {
        ShouldKt.shouldBe(Float.valueOf($this$shouldBeGreaterThan), MatchersKt.gt(x));
        return $this$shouldBeGreaterThan;
    }

    public static final float shouldNotBeGreaterThan(float $this$shouldNotBeGreaterThan, float x) {
        ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeGreaterThan), MatchersKt.gt(x));
        return $this$shouldNotBeGreaterThan;
    }

    public static final float shouldBeGreaterThanOrEqual(float $this$shouldBeGreaterThanOrEqual, float x) {
        ShouldKt.shouldBe(Float.valueOf($this$shouldBeGreaterThanOrEqual), MatchersKt.gte(x));
        return $this$shouldBeGreaterThanOrEqual;
    }

    public static final float shouldNotBeGreaterThanOrEqual(float $this$shouldNotBeGreaterThanOrEqual, float x) {
        ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeGreaterThanOrEqual), MatchersKt.gte(x));
        return $this$shouldNotBeGreaterThanOrEqual;
    }

    public static final float shouldBeExactly(float $this$shouldBeExactly, float x) {
        Matcher<Float> matcher = AssertionsConfig.INSTANCE.getDisableNaNEquality() ? ShouldKt.shouldBe(Float.valueOf($this$shouldBeExactly), MatchersKt.exactly(x)) : ShouldKt.shouldBe(Float.valueOf($this$shouldBeExactly), MatchersKt.exactlyByBits(x));
        return $this$shouldBeExactly;
    }

    public static final float shouldNotBeExactly(float $this$shouldNotBeExactly, float x) {
        float f = AssertionsConfig.INSTANCE.getDisableNaNEquality() ? ((Number)ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeExactly), MatchersKt.exactly(x))).floatValue() : ((Number)ShouldKt.shouldNotBe(Float.valueOf($this$shouldNotBeExactly), MatchersKt.exactlyByBits(x))).floatValue();
        return $this$shouldNotBeExactly;
    }

    public static final float shouldBeZero(float $this$shouldBeZero) {
        MatchersKt.shouldBeExactly($this$shouldBeZero, 0.0f);
        return $this$shouldBeZero;
    }

    public static final float shouldNotBeZero(float $this$shouldNotBeZero) {
        MatchersKt.shouldNotBeExactly($this$shouldNotBeZero, 0.0f);
        return $this$shouldNotBeZero;
    }

    public static final float shouldBeWithinPercentageOf(float $this$shouldBeWithinPercentageOf, float other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should(Float.valueOf($this$shouldBeWithinPercentageOf), MatchersKt.beWithinPercentageOf(other, percentage));
        return $this$shouldBeWithinPercentageOf;
    }

    public static final float shouldNotBeWithinPercentageOf(float $this$shouldNotBeWithinPercentageOf, float other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot(Float.valueOf($this$shouldNotBeWithinPercentageOf), MatchersKt.beWithinPercentageOf(other, percentage));
        return $this$shouldNotBeWithinPercentageOf;
    }

    @NotNull
    public static final Matcher<Float> beWithinPercentageOf(float other, double percentage) {
        return (Matcher)new Matcher<Float>(other, percentage){
            private final float tolerance;
            private final ClosedFloatingPointRange<Float> range;
            {
                this.tolerance = (float)Math.abs((double)$other * ($percentage / (double)100));
                this.range = RangesKt.rangeTo((float)($other - this.tolerance), (float)($other + this.tolerance));
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)Float.valueOf(value)), () -> beWithinPercentageOf.1.test$lambda$0(value, this), () -> beWithinPercentageOf.1.test$lambda$1(value, this));
            }

            public Matcher<Float> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return super.contramap(f);
            }

            public Matcher<Float> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(float $value, beWithinPercentageOf.1 this$0) {
                return $value + " should be in " + this$0.range;
            }

            private static final String test$lambda$1(float $value, beWithinPercentageOf.1 this$0) {
                return $value + " should not be in " + this$0.range;
            }
        };
    }
}

