/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.bigdecimal;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.bigdecimal.MatchersKt;
import io.kotest.matchers.comparables.ComparableMatchersKt;
import java.math.BigDecimal;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\n\u001a\u00020\b*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\f\u001a\u00020\b*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\r\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0013\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u001b\u0010\u0016\u001a\u00020\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0087\u0004\u001a\u001b\u0010\u001a\u001a\u00020\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0087\u0004\u001a\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019\u001a\u0015\u0010\u001d\u001a\u00020\u0017*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u001e\u001a\u00020\u0017*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0004\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u0001\u00a8\u0006 "}, d2={"shouldBeZero", "Ljava/math/BigDecimal;", "shouldBePositive", "", "shouldBeNegative", "shouldNotBePositive", "shouldNotBeNegative", "shouldHavePrecision", "", "precision", "shouldHaveScale", "scale", "shouldNotHaveScale", "shouldBeLessThan", "other", "shouldBeLessThanOrEquals", "shouldNotBeLessThan", "shouldNotBeLessThanOrEquals", "shouldBeGreaterThan", "shouldBeGreaterThanOrEquals", "shouldNotBeGreaterThan", "shouldNotBeGreaterThanOrEquals", "shouldBeInRange", "", "range", "Lkotlin/ranges/ClosedRange;", "shouldNotBeInRange", "beInClosedRange", "Lio/kotest/matchers/Matcher;", "shouldBeEqualIgnoringScale", "shouldNotBeEqualIgnoringScale", "beEqualIgnoringScale", "kotest-assertions-core"})
public final class MatchersKt {
    @NotNull
    public static final BigDecimal shouldBeZero(@NotNull BigDecimal $this$shouldBeZero) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeZero, (String)"<this>");
        return ShouldKt.shouldBe($this$shouldBeZero, BigDecimal.ZERO);
    }

    @NotNull
    public static final Object shouldBePositive(@NotNull BigDecimal $this$shouldBePositive) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBePositive, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        return ShouldKt.shouldBe($this$shouldBePositive, ComparableMatchersKt.gt((Comparable)bigDecimal));
    }

    @NotNull
    public static final Object shouldBeNegative(@NotNull BigDecimal $this$shouldBeNegative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeNegative, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        return ShouldKt.shouldBe($this$shouldBeNegative, ComparableMatchersKt.lt((Comparable)bigDecimal));
    }

    @NotNull
    public static final BigDecimal shouldNotBePositive(@NotNull BigDecimal $this$shouldNotBePositive) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBePositive, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        return ShouldKt.shouldNotBe($this$shouldNotBePositive, ComparableMatchersKt.gt((Comparable)bigDecimal));
    }

    @NotNull
    public static final BigDecimal shouldNotBeNegative(@NotNull BigDecimal $this$shouldNotBeNegative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeNegative, (String)"<this>");
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        return ShouldKt.shouldNotBe($this$shouldNotBeNegative, ComparableMatchersKt.lt((Comparable)bigDecimal));
    }

    public static final int shouldHavePrecision(@NotNull BigDecimal $this$shouldHavePrecision, int precision) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHavePrecision, (String)"<this>");
        return ((Number)ShouldKt.shouldBe($this$shouldHavePrecision.precision(), precision)).intValue();
    }

    public static final int shouldHaveScale(@NotNull BigDecimal $this$shouldHaveScale, int scale) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveScale, (String)"<this>");
        return ((Number)ShouldKt.shouldBe($this$shouldHaveScale.scale(), scale)).intValue();
    }

    public static final int shouldNotHaveScale(@NotNull BigDecimal $this$shouldNotHaveScale, int scale) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveScale, (String)"<this>");
        return ((Number)ShouldKt.shouldNotBe($this$shouldNotHaveScale.scale(), scale)).intValue();
    }

    @NotNull
    public static final Object shouldBeLessThan(@NotNull BigDecimal $this$shouldBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLessThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldBe($this$shouldBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    @NotNull
    public static final Object shouldBeLessThanOrEquals(@NotNull BigDecimal $this$shouldBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLessThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldBe($this$shouldBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    @NotNull
    public static final BigDecimal shouldNotBeLessThan(@NotNull BigDecimal $this$shouldNotBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLessThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldNotBe($this$shouldNotBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    @NotNull
    public static final BigDecimal shouldNotBeLessThanOrEquals(@NotNull BigDecimal $this$shouldNotBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLessThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldNotBe($this$shouldNotBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    @NotNull
    public static final Object shouldBeGreaterThan(@NotNull BigDecimal $this$shouldBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeGreaterThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldBe($this$shouldBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    @NotNull
    public static final Object shouldBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeGreaterThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldBe($this$shouldBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    @NotNull
    public static final BigDecimal shouldNotBeGreaterThan(@NotNull BigDecimal $this$shouldNotBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeGreaterThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldNotBe($this$shouldNotBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    @NotNull
    public static final BigDecimal shouldNotBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldNotBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeGreaterThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ShouldKt.shouldNotBe($this$shouldNotBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    @Deprecated(message="use <T: Comparable<T>> shouldBeIn", replaceWith=@ReplaceWith(expression="this shouldBeIn (range)", imports={"io.kotest.matchers.ranges.shouldBeIn"}))
    public static final void shouldBeInRange(@NotNull BigDecimal $this$shouldBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ShouldKt.should($this$shouldBeInRange, MatchersKt.beInClosedRange(range));
    }

    @Deprecated(message="use <T: Comparable<T>> shouldNotBeIn", replaceWith=@ReplaceWith(expression="this shouldNotBeIn (range)", imports={"io.kotest.matchers.ranges.shouldNotBeIn"}))
    public static final void shouldNotBeInRange(@NotNull BigDecimal $this$shouldNotBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ShouldKt.shouldNot($this$shouldNotBeInRange, MatchersKt.beInClosedRange(range));
    }

    @NotNull
    public static final Matcher<BigDecimal> beInClosedRange(@NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return (Matcher)new Matcher<BigDecimal>(range){
            final /* synthetic */ ClosedRange<BigDecimal> $range;
            {
                this.$range = $range;
            }

            public MatcherResult test(BigDecimal value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.$range.contains((Comparable)value), () -> beInClosedRange.1.test$lambda$0(value, this.$range), () -> beInClosedRange.1.test$lambda$1(value, this.$range));
            }

            public Matcher<BigDecimal> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends BigDecimal> f) {
                return super.contramap(f);
            }

            public Matcher<BigDecimal> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(BigDecimal $value, ClosedRange $range) {
                return "Value " + $value + " should be in range from " + $range.getStart() + " to " + $range.getEndInclusive() + " (Inclusive)";
            }

            private static final String test$lambda$1(BigDecimal $value, ClosedRange $range) {
                return "Value " + $value + " should not be in range from " + $range.getStart() + " to " + $range.getEndInclusive() + " (Inclusive)";
            }
        };
    }

    public static final void shouldBeEqualIgnoringScale(@NotNull BigDecimal $this$shouldBeEqualIgnoringScale, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEqualIgnoringScale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeEqualIgnoringScale, MatchersKt.beEqualIgnoringScale(other));
    }

    public static final void shouldNotBeEqualIgnoringScale(@NotNull BigDecimal $this$shouldNotBeEqualIgnoringScale, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEqualIgnoringScale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeEqualIgnoringScale, MatchersKt.beEqualIgnoringScale(other));
    }

    @NotNull
    public static final Matcher<BigDecimal> beEqualIgnoringScale(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<BigDecimal>(other){
            final /* synthetic */ BigDecimal $other;
            {
                this.$other = $other;
            }

            public MatcherResult test(BigDecimal value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.compareTo(this.$other) == 0, () -> beEqualIgnoringScale.1.test$lambda$0(value, this.$other), () -> beEqualIgnoringScale.1.test$lambda$1(value, this.$other));
            }

            public Matcher<BigDecimal> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends BigDecimal> f) {
                return super.contramap(f);
            }

            public Matcher<BigDecimal> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$0(BigDecimal $value, BigDecimal $other) {
                return "BigDecimal " + $value + " should be equal ignoring scale to " + $other;
            }

            private static final String test$lambda$1(BigDecimal $value, BigDecimal $other) {
                return "BigDecimal " + $value + " should not be equal ignoring scale to " + $other;
            }
        };
    }
}

