/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.similarity;

import io.kotest.assertions.similarity.AtomicMismatch;
import io.kotest.assertions.similarity.ComparisonResult;
import io.kotest.assertions.similarity.Distance;
import io.kotest.assertions.similarity.Match;
import io.kotest.assertions.similarity.StringMismatch;
import io.kotest.assertions.submatching.PartialCollectionMatch;
import io.kotest.assertions.submatching.PartialMatchesInStringDescription;
import io.kotest.assertions.submatching.StringPartialMatchesKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a&\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u00a8\u0006\r"}, d2={"matchNotNullStrings", "Lio/kotest/assertions/similarity/ComparisonResult;", "field", "", "expected", "actual", "partialMatchesAreUnordered", "", "partialMatches", "", "Lio/kotest/assertions/submatching/PartialCollectionMatch;", "ratioOfPartialMatchesInString", "Ljava/math/BigDecimal;", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nStringDistanceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringDistanceCalculator.kt\nio/kotest/assertions/similarity/StringDistanceCalculatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1056#2:46\n1761#2,3:47\n1#3:50\n*S KotlinDebug\n*F\n+ 1 StringDistanceCalculator.kt\nio/kotest/assertions/similarity/StringDistanceCalculatorKt\n*L\n29#1:46\n30#1:47,3\n*E\n"})
public final class StringDistanceCalculatorKt {
    @NotNull
    public static final ComparisonResult matchNotNullStrings(@NotNull String field, @NotNull String expected, @NotNull String actual) {
        ComparisonResult comparisonResult;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        if (Intrinsics.areEqual((Object)expected, (Object)actual)) {
            comparisonResult = new Match(field, expected);
        } else {
            PartialMatchesInStringDescription comparison = StringPartialMatchesKt.describePartialMatchesInStringForSlice(expected, actual, true);
            BigDecimal ratioOfPartialMatches = StringDistanceCalculatorKt.ratioOfPartialMatchesInString(comparison.getPartialMatches(), expected, actual);
            boolean partialMatchesAreUnordered = StringDistanceCalculatorKt.partialMatchesAreUnordered(comparison.getPartialMatches());
            BigDecimal discountForUnorderedPartialMatches = partialMatchesAreUnordered ? new BigDecimal("0.8") : BigDecimal.ONE;
            BigDecimal bigDecimal = ratioOfPartialMatches.multiply(discountForUnorderedPartialMatches);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
            Distance distance = new Distance(bigDecimal);
            comparisonResult = distance.aboveThresholdForStrings() ? (ComparisonResult)new StringMismatch(field, expected, actual, comparison.toString(), distance) : (ComparisonResult)new AtomicMismatch(field, expected, actual, null, 8, null);
        }
        return comparisonResult;
    }

    public static final boolean partialMatchesAreUnordered(@NotNull List<PartialCollectionMatch> partialMatches) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(partialMatches, (String)"partialMatches");
            Iterable $this$sortedBy$iv = partialMatches;
            boolean $i$f$sortedBy = false;
            Iterable $this$any$iv = CollectionsKt.zipWithNext((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PartialCollectionMatch it = (PartialCollectionMatch)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getMatchedElement().getStartIndexInExpected());
                    it = (PartialCollectionMatch)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMatchedElement().getStartIndexInExpected()));
                }
            }));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    PartialCollectionMatch first = (PartialCollectionMatch)pair.component1();
                    PartialCollectionMatch second = (PartialCollectionMatch)pair.component2();
                    if (!(first.getMatchedElement().getStartIndexInValue() > second.getMatchedElement().getStartIndexInValue())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigDecimal ratioOfPartialMatchesInString(@NotNull List<PartialCollectionMatch> partialMatches, @NotNull String expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter(partialMatches, (String)"partialMatches");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Object[] objectArray = new String[]{expected, actual};
        Object object = ((Iterable)CollectionsKt.listOf((Object[])objectArray)).iterator();
        if (!object.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)object.next();
        boolean bl = false;
        int n = it.length();
        while (object.hasNext()) {
            String it2 = (String)object.next();
            $i$a$-maxOf-StringDistanceCalculatorKt$ratioOfPartialMatchesInString$maxLength$1 = false;
            int n2 = it2.length();
            if (n >= n2) continue;
            n = n2;
        }
        int maxLength = n;
        object = partialMatches;
        n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it3;
            Object t = iterator.next();
            PartialCollectionMatch partialCollectionMatch = (PartialCollectionMatch)t;
            int n3 = n;
            boolean bl2 = false;
            int n4 = it3.getLength();
            n = n3 + n4;
        }
        int numberOfMatchedCharacters = n;
        BigDecimal bigDecimal = BigDecimal.valueOf(numberOfMatchedCharacters).divide(BigDecimal.valueOf(maxLength), 2, RoundingMode.HALF_DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"divide(...)");
        return bigDecimal;
    }
}

