/*
 * Decompiled with CFR 0.152.
 */
package io.klogging.hexagonkt;

import com.hexagonkt.core.logging.LoggerPort;
import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingPort;
import io.klogging.NoCoLogger;
import io.klogging.NoCoLoggingKt;
import io.klogging.hexagonkt.KloggingAdapterKt;
import io.klogging.hexagonkt.NoCoLoggerAdapter;
import io.klogging.impl.NoCoLoggerImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/klogging/hexagonkt/KloggingAdapter;", "Lcom/hexagonkt/core/logging/LoggingPort;", "()V", "loggerLevels", "", "", "Lcom/hexagonkt/core/logging/LoggingLevel;", "createLogger", "Lcom/hexagonkt/core/logging/LoggerPort;", "name", "isLoggerLevelEnabled", "", "level", "setLoggerLevel", "", "hexagonkt-klogging-adapter"})
public final class KloggingAdapter
implements LoggingPort {
    @NotNull
    private final Map<String, LoggingLevel> loggerLevels = new LinkedHashMap();

    @NotNull
    public LoggerPort createLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new NoCoLoggerAdapter((NoCoLogger)new NoCoLoggerImpl(name));
    }

    public boolean isLoggerLevelEnabled(@NotNull String name, @NotNull LoggingLevel level) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LoggingLevel loggingLevel = this.loggerLevels.get(name);
        if (loggingLevel != null) {
            LoggingLevel loggerLevel = loggingLevel;
            boolean bl2 = false;
            bl = loggerLevel.compareTo((Enum)level) <= 0;
        } else {
            bl = NoCoLoggingKt.noCoLogger((String)name).isLevelEnabled(KloggingAdapterKt.getKloggingLevel(level));
        }
        return bl;
    }

    public void setLoggerLevel(@NotNull String name, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.loggerLevels.put(name, level);
    }
}

