/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.joynrandroidruntime;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Messenger;
import com.google.inject.Module;
import io.joynr.capabilities.RegistrationFuture;
import io.joynr.dispatcher.rpc.JoynrInterface;
import io.joynr.joynrandroidruntime.AndroidProxyBuilder;
import io.joynr.joynrandroidruntime.InitRuntimeTask;
import io.joynr.joynrandroidruntime.UILogger;
import io.joynr.provider.JoynrProvider;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.runtime.JoynrRuntime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public class JoynrAndroidRuntime
implements JoynrRuntime {
    protected InitRuntimeTask runtimeInitTask;
    protected static UILogger uiLogger = new UILogger();

    public JoynrAndroidRuntime(Context applicationContext) {
        this.runtimeInitTask = new InitRuntimeTask(applicationContext, uiLogger);
        this.runtimeInitTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
    }

    public JoynrAndroidRuntime(Context applicationContext, Properties joynrConfig) {
        this.runtimeInitTask = new InitRuntimeTask(joynrConfig, applicationContext, uiLogger, Collections.emptyList());
        this.runtimeInitTask.execute(new Object[0]);
    }

    public JoynrAndroidRuntime(Context applicationContext, Properties joynrConfig, Module ... joynrModules) {
        this.runtimeInitTask = new InitRuntimeTask(joynrConfig, applicationContext, uiLogger, Arrays.asList(joynrModules));
        this.runtimeInitTask.execute(new Object[0]);
    }

    private JoynrRuntime getJoynrRuntime() {
        JoynrRuntime runtime;
        try {
            runtime = (JoynrRuntime)this.runtimeInitTask.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            uiLogger.logText(e.getMessage());
            return null;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            uiLogger.logText(e.getMessage());
            return null;
        }
        return runtime;
    }

    public RegistrationFuture registerProvider(String domain, JoynrProvider provider) {
        JoynrRuntime runtime = this.getJoynrRuntime();
        RegistrationFuture future = runtime.registerProvider(domain, provider);
        return future;
    }

    public void unregisterProvider(String domain, JoynrProvider provider) {
        JoynrRuntime runtime = this.getJoynrRuntime();
        runtime.unregisterProvider(domain, provider);
    }

    public <T extends JoynrInterface> ProxyBuilder<T> getProxyBuilder(String domain, Class<T> interfaceClass) {
        return new AndroidProxyBuilder<T>(this.runtimeInitTask, domain, interfaceClass, uiLogger);
    }

    public void addLogListener(Messenger clientMessenger) {
        uiLogger.addLogListener(clientMessenger);
    }

    public void removeLogListener(Messenger clientMessanger) {
        uiLogger.removeLogListener(clientMessanger);
    }

    public void shutdown(boolean clear) {
        JoynrRuntime runtime = this.getJoynrRuntime();
        runtime.shutdown(clear);
    }
}

