/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.joynrandroidruntime;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.joynr.joynrandroidruntime.UILogger;
import io.joynr.joynrandroidruntime.messaging.AndroidLongPollingMessagingModule;
import io.joynr.runtime.JoynrInjectorFactory;
import io.joynr.runtime.JoynrRuntime;
import io.joynr.runtime.JoynrRuntimeImpl;
import io.joynr.runtime.PropertyLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class InitRuntimeTask
extends AsyncTask<Object, String, JoynrRuntime> {
    public static final long INIT_TIMEOUT = 30000L;
    private UILogger uiLogger;
    private Context applicationContext;
    private Properties joynrConfig;
    private List<Module> modules;

    public InitRuntimeTask(Context applicationContext, UILogger uiLogger) {
        this(PropertyLoader.loadProperties((String)"res/raw/demo.properties"), applicationContext, uiLogger, Collections.emptyList());
    }

    public InitRuntimeTask(Properties joynrConfig, Context applicationContext, UILogger uiLogger, List<Module> joynrModules) {
        this.joynrConfig = joynrConfig;
        this.applicationContext = applicationContext;
        this.uiLogger = uiLogger;
        this.modules = new ArrayList<Module>();
        this.modules.add((Module)new AndroidLongPollingMessagingModule());
        this.modules.addAll(joynrModules);
    }

    protected JoynrRuntime doInBackground(Object ... params) {
        try {
            Log.d((String)"JAS", (String)"starting joynr runtime");
            this.publishProgress(new String[]{"Starting joynr runtime...\n"});
            File appWorkingDir = this.applicationContext.getFilesDir();
            String persistenceFileName = appWorkingDir.getPath() + File.separator + this.joynrConfig.getProperty("joynr.messaging.persistence_file", "joynr.properties");
            this.joynrConfig.setProperty("joynr.messaging.persistence_file", persistenceFileName);
            String participantIdPersistenceFileName = appWorkingDir.getPath() + File.separator + this.joynrConfig.getProperty("joynr.discovery.participantids_persistence_file", "joynr_participantIds.properties");
            this.joynrConfig.setProperty("joynr.discovery.participantids_persistence_file", participantIdPersistenceFileName);
            this.publishProgress(new String[]{"Properties loaded\n"});
            this.joynrConfig.setProperty("joynr.discovery.requesttimeout", "120000");
            Module[] moduleArray = this.modules.toArray(new Module[this.modules.size()]);
            Injector injectorA = new JoynrInjectorFactory(this.joynrConfig, moduleArray).createChildInjector(new Module[0]);
            JoynrRuntimeImpl runtime = (JoynrRuntimeImpl)injectorA.getInstance(JoynrRuntimeImpl.class);
            if (runtime != null) {
                Log.d((String)"JAS", (String)"joynr runtime started");
            } else {
                Log.e((String)"JAS", (String)"joynr runtime not started");
            }
            this.publishProgress(new String[]{"joynr runtime started.\n"});
            return runtime;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.publishProgress(new String[]{e.getMessage()});
            return null;
        }
    }

    protected void onProgressUpdate(String ... progress) {
        this.uiLogger.logText(progress);
    }
}

