/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.joynrandroidruntime;

import android.os.AsyncTask;
import android.util.Log;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.dispatcher.rpc.JoynrInterface;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.joynrandroidruntime.InitRuntimeTask;
import io.joynr.joynrandroidruntime.UILogger;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.runtime.JoynrRuntime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AndroidProxyBuilder<T extends JoynrInterface>
extends AsyncTask<Object, String, T>
implements ProxyBuilder<T> {
    private JoynrRuntime runtime;
    private String providerDomain;
    private MessagingQos messagingQos;
    private DiscoveryQos discoveryQos;
    private UILogger uiLogger;
    private ProxyBuilder.ProxyCreatedCallback<T> callback = null;
    Class<T> proxyInterface;
    private String participantId = null;
    private ProxyBuilder<T> builder = null;
    private InitRuntimeTask runtimeInitTask;

    public AndroidProxyBuilder(InitRuntimeTask runtimeInitTask, String providerDomain, Class<T> proxyInterface, UILogger uiLogger) {
        this.runtimeInitTask = runtimeInitTask;
        this.providerDomain = providerDomain;
        this.proxyInterface = proxyInterface;
        this.uiLogger = uiLogger;
    }

    protected T doInBackground(Object ... arg0) {
        Log.d((String)"JAS", (String)"starting CreateProxy");
        try {
            return this.buildProxy();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (this.callback != null) {
                this.callback.onProxyCreationError(e.getMessage());
            }
            return null;
        }
    }

    protected T buildProxy() throws InterruptedException, ExecutionException, TimeoutException {
        this.runtime = (JoynrRuntime)this.runtimeInitTask.get(this.discoveryQos.getDiscoveryTimeout(), TimeUnit.MILLISECONDS);
        this.builder = this.runtime.getProxyBuilder(this.providerDomain, this.proxyInterface);
        if (this.participantId != null) {
            this.builder.setParticipantId(this.participantId);
        }
        JoynrInterface proxy = this.builder.setMessagingQos(this.messagingQos).setDiscoveryQos(this.discoveryQos).build();
        Log.d((String)"JAS", (String)"Returning Proxy");
        return (T)proxy;
    }

    protected void onProgressUpdate(String ... progress) {
        this.uiLogger.logText(progress);
    }

    protected void onPostExecute(T result) {
        if (result != null && this.callback != null) {
            Log.d((String)"JAS", (String)"calling onProxyCreated Callback");
            this.callback.onProxyCreated(result);
        }
    }

    public String getParticipantId() {
        if (this.builder != null) {
            this.participantId = this.builder.getParticipantId();
        }
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
        if (this.builder != null) {
            this.builder.setParticipantId(participantId);
        }
    }

    public ProxyBuilder<T> setDiscoveryQos(DiscoveryQos discoveryQos) throws DiscoveryException {
        this.discoveryQos = discoveryQos;
        return this;
    }

    public ProxyBuilder<T> setMessagingQos(MessagingQos messagingQos) {
        this.messagingQos = messagingQos;
        return this;
    }

    public T build() {
        throw new UnsupportedOperationException("On Android, only method signature public void build(ProxyCreatedCallback<T> newCallback) is supported");
    }

    public void build(ProxyBuilder.ProxyCreatedCallback<T> newCallback) {
        this.callback = newCallback;
        this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
    }
}

